% Generated by roxygen2 (4.0.2): do not edit by hand
\name{Holt}
\alias{Holt}
\title{Holt's Two-parameter Exponential Smoothing}
\usage{
Holt(x, type = c("additive", "multiplicative"), alpha = 0.2,
  beta = 0.1057, lead = 0, damped = FALSE, phi = 0.98, plot = TRUE)
}
\arguments{
\item{x}{a numeric vector or univariate time series.}

\item{type}{the type of interaction between the level and the linear trend. See
details.}

\item{alpha}{the parameter for the level smoothing. The default is \code{0.2}.}

\item{beta}{the parameter for the trend smoothing. The default is \code{0.1057}.}

\item{lead}{the number of steps ahead for which prediction is required.
The default is \code{0}.}

\item{damped}{a logical value indicating a damped trend. See details. The default is
\code{FALSE}.}

\item{phi}{a smoothing parameter for damped trend. The default is \code{0.98}, only valid
for \code{damped = TRUE}.}

\item{plot}{a logical value indicating to print the plot of original data v.s smoothed
data. The default is \code{TRUE}.}
}
\value{
A list with class "\code{Holt}" containing the following components:
\item{estimate}{the estimate values.}
\item{alpha}{the smoothing parameter used for level.}
\item{beta}{the smoothing parameter used for trend.}
\item{phi}{the smoothing parameter used for damped trend.}
\item{pred}{the predicted values, only available for \code{lead} > 0.}
\item{accurate}{the accurate measurements.}
}
\description{
Performs Holt's two-parameter exponential smoothing for linear
trend or damped trend.
}
\details{
Holt's two parameter is used to forecast a time series with trend, but
wihtout seasonal pattern. For the additive model (\code{type = "additive"}), the
\eqn{h}-step-ahead forecast is given by \eqn{hat{x}[t+h|t] = level[t] + h*b[t]},
 where
\deqn{level[t] = \alpha *x[t] + (1-\alpha)*(b[t-1] + level[t-1]),}
\deqn{b[t] = \beta*(level[t] - level[t-1]) + (1-\beta)*b[t-1],}
in which \eqn{b[t]} is the trend component.
For the multiplicative (\code{type = "multiplicative"}) model, the
\eqn{h}-step-ahead forecast is given by \eqn{hat{x}[t+h|t] = level[t] + h*b[t]},
 where
\deqn{level[t] = \alpha *x[t] + (1-\alpha)*(b[t-1] * level[t-1]),}
\deqn{b[t] = \beta*(level[t] / level[t-1]) + (1-\beta)*b[t-1].}

Compared with the Holt's linear trend that displays a constant increasing or
decreasing, the damped trend generated by exponential smoothing method shows a
exponential growth or decline, which is a situation between simple exponential
smoothing (with 0 increasing or decreasing rate) and Holt's two-parameter smoothing.
If \code{damped = TRUE}, the additive model becomes
\deqn{hat{x}[t+h|t] = level[t] + (\phi + \phi^{2} + ... + \phi^{h})*b[t],}
\deqn{level[t] = \alpha *x[t] + (1-\alpha)*(\phi*b[t-1] + level[t-1]),}
\deqn{b[t] = \beta*(level[t] - level[t-1]) + (1-\beta)*\phi*b[t-1].}
The multiplicative model becomes
\deqn{hat{x}[t+h|t] = level[t] *b[t]^(\phi + \phi^{2} + ... + \phi^{h}),}
\deqn{level[t] = \alpha *x[t] + (1-\alpha)*(b[t-1]^{\phi} * level[t-1]),}
\deqn{b[t] = \beta*(level[t] / level[t-1]) + (1-\beta)*b[t-1]^{\phi}.}
See Chapter 7.4 for more details in R. J. Hyndman and G. Athanasopoulos (2013).
}
\note{
Missing values are removed before analysis.
}
\examples{
x <- (1:100)/100
y <- 2 + 1.2*x + rnorm(100)

ho0 <- Holt(y) # with additive interaction
ho1 <- Holt(y,damped = TRUE) # with damped trend

# multiplicative model for AirPassengers data,
# although seasonal pattern exists.
ho2 <- Holt(AirPassengers,type = "multiplicative")
}
\author{
Debin Qiu
}
\references{
R. J. Hyndman and G. Athanasopoulos, "Forecasting: principles and
practice," 2013. [Online]. Available: \url{http://otexts.org/fpp/}.
}
\seealso{
\code{\link{HoltWinters}}, \code{\link{expsmooth}}, \code{\link{Winters}}
}

