% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abbreviate_text.R
\name{abbreviate_text}
\alias{abbreviate_text}
\title{abbreviate_text}
\usage{
abbreviate_text(txt, minlength = 3, alnum = TRUE)
}
\arguments{
\item{txt}{character: vector of strings to abbreviate}

\item{minlength}{integer: the minimum length of the abbreviations}

\item{alnum}{logical: should strings be reduced to alpha-numeric characters before abbreviation (default: \code{TRUE})}
}
\value{
abbreviated strings
}
\description{
Shorten strings to at least \code{minlength} characters so that they remain unique (if they were).
Duplicate strings or \code{NA}s are allowed. Note that different orders in the string may result
in different abbreviations.
}
\examples{
# unique with first letters is possible
txt <- c("euclidean", "maximum", "manhattan", "canberra", "minimum")
abbreviate_text(txt, 3)
# if identical strings used then same abbreviation
txt <- c("euclidean", "maximum", "manhattan", "manhattan", "canberra", "minimum")
abbreviate_text(txt, 3)
# warnings that identical strings and identical abbreviations used
txt <- c("euclidean", "maximum", "manhattan", NA, "canberra", "minimum", "abc", "abc")
abbreviate_text(txt, 3)
# unique abbreviations
txt <- c("ward.D", "ward.D2", "single", "complete", "average", "mcquitty", "median", "centroid")
abbreviate_text(txt, 3)
# unique abbreviations, but not really intuitive
abbreviate_text(txt, 0)
}
\seealso{
\link[base:abbreviate]{base::abbreviate} or \href{https://CRAN.R-project.org/package=uniqtag}{package \code{uniqtag}}
}
