% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_urls.R
\name{check_urls}
\alias{check_urls}
\title{Check an Rmarkdown for broken links.}
\usage{
check_urls(rmd_path)
}
\arguments{
\item{rmd_path}{Path to the Rmd that requires links to be checked. Rmd must
be output type html.}
}
\value{
Lines of any urls that respond with an error.
}
\description{
Check links within an Rmarkdown document for any urls that responds with an
error.
}
\examples{
\dontshow{
.old_wd <- setwd(tempdir())
}
# create a testfile
links <- tempfile("mixed_links", fileext = ".rmd")
file.create(links)
writeLines("[a good link](https://datasciencecampus.ons.gov.uk/)
[a bad link](https://datasciencecampus.ons.gov.uk/broken)",
  con = links
)
# Test the file
check_urls(links)
\dontshow{
setwd(.old_wd)
}

}
