% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accucor_lib.R
\name{nitrogen_isotope_correction}
\alias{nitrogen_isotope_correction}
\title{Natural Abundance deuterium isotope correction for one metabolite}
\usage{
nitrogen_isotope_correction(
  formula,
  datamatrix,
  label,
  Resolution,
  ResDefAt = 200,
  purity = 0.99,
  ReportPoolSize = TRUE
)
}
\arguments{
\item{formula}{String representing molecular formula}

\item{datamatrix}{Matrix of abundances for each sample for each isotope}

\item{label}{vector of integer labels}

\item{Resolution}{For Exactive, the Resolution is 100000, defined at Mw 200}

\item{ResDefAt}{Resolution defined at (in Mw), e.g. 200 Mw}

\item{purity}{Nitrogen purity, default: 0.99}

\item{ReportPoolSize}{default: TRUE}
}
\value{
Named list of matrices: 'Corrected', 'Normalized',
     'PoolBeforeDF', and 'PoolAfterDF'.
}
\description{
Natural Abundance deuterium isotope correction for one metabolite
}
\examples{
\dontrun{
nitrogen_isotope_correction(
  formula = "C23H38N7O17P3S",
  datamatrix = DataMatrix,
  label = c(0, 1, 2, 3, 4, 5, 6, 7),
  Resolution = 140000
)
}
}
