library(ggplot2)
test_that("Udaplot works without the estimated normal pdf curve for original data", {
  set.seed(2025)
  X<-sort(matrix(rnorm(100, mean = 2 , sd = 5)))
  g1=udaplot(X,excld=FALSE,npdf=FALSE,xlab="x",lcol="black",rcol="grey60",pdfcol="red")
  expect_true(is_ggplot(g1))
})

test_that("Udaplot works with the estimated normal pdf curve for original data", {
  set.seed(2025)
  X<-sort(matrix(rnorm(100, mean = 2 , sd = 5)))
  g2=udaplot(X,excld=FALSE,npdf=TRUE,xlab="x",lcol="black",rcol="grey60",pdfcol="red")
  expect_true(is_ggplot(g2))
})

test_that("Udaplot works without the estimated normal pdf curve for 1.5IQR ruled data", {
  set.seed(2025)
  X1<-matrix(rnorm(100, mean = 2 , sd = 5))
  X=sort(matrix(append(X1,c(42))))
  g3=udaplot(X,excld=TRUE,npdf=FALSE,xlab="x",lcol="black",rcol="grey60",pdfcol="red")
  expect_true(is_ggplot(g3))
})

test_that("Udaplot works with the estimated normal pdf curve for  1.5IQR ruled data", {
  set.seed(2025)
  X1<-matrix(rnorm(100, mean = 2 , sd = 5))
  X=sort(matrix(append(X1,c(42))))
  g4=udaplot(X,excld=TRUE,npdf=TRUE,xlab="x",lcol="black",rcol="grey60",pdfcol="red")
  expect_true(is_ggplot(g4))
})
