% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapt-model.R
\name{gen_adapt_model}
\alias{gen_adapt_model}
\title{adapt_model Objects for M-steps}
\usage{
gen_adapt_model(pifun = NULL, mufun = NULL, pifun_init = NULL,
  mufun_init = NULL, piargs = list(), muargs = list(),
  piargs_init = list(), muargs_init = list(), name = "")
}
\arguments{
\item{pifun}{a function to fit pi(x). See Details}

\item{mufun}{a function to fit mu(x). See Details}

\item{pifun_init}{a function to fit pi(x) at the initial step}

\item{mufun_init}{a function to fit mu(x) at the initial step}

\item{piargs}{a list. Arguments for "pifun". An empty list as default}

\item{muargs}{a list. Arguments for "mufun". An empty list as default}

\item{piargs_init}{a list. Arguments for piargs_init. An empty list as default}

\item{muargs_init}{a list. Arguments for muargs_init. An empty list as default}

\item{name}{a string. An optional argument for the user-specified name of the model. An empty string as default.}
}
\value{
\item{name}{same as the input \code{name}}
\item{algo}{a list recording \code{pifun}, \code{mufun}, \code{pifun_init} and \code{mufun_init}}
\item{args}{a list recording \code{piargs}, \code{muargs}, \code{piargs_init} and \code{muargs_init}}
}
\description{
\code{adapt_model} objects provide the functions and their arguments in computing the M-steps.
Each object can be passed to \code{\link{adapt}} as a candidate model.
}
\details{
\code{pifun} should be in the form of \code{pifun(formula, data, family, weights, ...)} or \code{pifun(x, y, family, ...)}.
The former includes \code{\link[stats]{glm}} and \code{\link[mgcv]{gam}} and the latter includes \code{\link[glmnet]{glmnet}}.
The outputs should be in the form of \code{list(fitv = , info = , ...)} where \code{fitv} gives the estimate of pi(x),
as a vector with the same order of \code{x}, and \code{info} should at least contain a key \code{df} if model selection is used, i.e. \code{info = list(df = , ...)}

\code{mufun} should be in the form of \code{pifun(formula, data, family, weights, ...)} or \code{pifun(x, y, family, weights, ...)}.
Note that \code{mufun} must take \code{weights} as an input. The outputs should be in the same form as \code{pifun} except that \code{fitv} should give the estimate of mu(x).

When \code{pifun} / \code{mufun} takes the form of \code{(formula, family, ...)}, \code{piargs} / \code{muargs} should at least contain a key \code{formula}; when \code{pifun} / \code{mufun} takes the form of \code{(x, y, family, ...)}, \code{piargs} / \code{muargs} can be empty.

For glm/gam/glmnet, one can use the shortcut by running \code{\link{gen_adapt_model}} with name = "glm" or "gam" or "glmnet" but without specifying \code{pifun}, \code{mufun}, \code{pifun_init} and \code{mufun_init}. See examples below.
}
\examples{
\donttest{
# Exemplary code to generate 'adapt_model' for logistic-Gamma glm  with naive initialization.
# The real implementation in the package is much more complicated.

# pifun as a logistic regression
pifun <- function(formula, data, weights, ...){
  glm(formula, data, weights = weights, family = binomial(),  ...)
}
# pifun_init as a constant
pifun_init <- function(x, pvals, s, ...){
  rep(0.1, length(pvals))
}
# mufun as a Gamma GLM
mufun <- function(formula, data, weights, ...){
  glm(formula, data, weights = weights, family = Gamma(), ...)
}
# mufun_init as a constant
mufun_init <- function(x, pvals, s, ...){
  rep(1.5, length(pvals))
}

library("splines") # for using ns() in the formula
piargs <- list(formula = "ns(x, df = 8)")
muargs <- list(formula = "ns(x, df = 8)")
name <- "glm"

mod <- gen_adapt_model(pifun, mufun, pifun_init, mufun_init,
                       piargs, muargs, name = name)
mod

# Using shortcut for GLM. See the last paragraph of Details.
mod2 <- gen_adapt_model(name = "glm", piargs = piargs, muargs = muargs)
mod2
}

}
