% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exp-family.R
\name{gen_exp_family}
\alias{gen_exp_family}
\alias{beta_family}
\alias{inv_gaussian_family}
\title{Generate exp_family Objects for Exponential Families}
\usage{
gen_exp_family(g, ginv, eta, mustar, A, name = NULL, family = NULL)

beta_family()

inv_gaussian_family()
}
\arguments{
\item{g}{a function. An transformation of p-values}

\item{ginv}{a function. The inverse function of \code{g}}

\item{eta}{a function. The natural parameter as a function of the mean parameter \code{mu}}

\item{mustar}{a scalar. The mean parameter that gives \eqn{U([0, 1])}}

\item{A}{a function. The partition function}

\item{name}{a string. A name for the family. NULL by default}

\item{family}{an object of class "\code{\link[stats]{family}}" from \code{stats} package. The family used for model fitting in \code{\link[stats]{glm}}, \code{\link[mgcv]{gam}}, \code{\link[glmnet]{glmnet}}, etc..}
}
\value{
an object of class "exp_family". This includes all inputs and  \code{h}, the density function.
}
\description{
\code{exp_family} objects contain all required information in an exponential family to perform the E-step. The exponential function is encoded by
\deqn{h(p; \mu) = \exp\{(\eta(\mu) - \eta(\mu^{*})) g(p) - (A(\mu) - A(\mu^{*}))\}}{h(p; \eta) = exp{(\eta(\mu) - \eta(\mu*)) g(p) - (A(\mu) - A(\mu*))}}
where \eqn{g(p)} is an arbitrary transformation, \eqn{\mu} is the
\emph{mean parameter}, \eqn{\eta} is the natural parameter,
and \eqn{A(\mu)} is the partition function. The extra redundant
parameter \eqn{\mu^{*}}{\mu*} is to guarantee that \eqn{U([0, 1])}
belongs to the class.
}
\details{
Beta family (\code{beta_family()}): modeling p-values as Beta-distributed random variables, i.e. \eqn{g(p) = -log(p)}, \eqn{\eta(\mu) = -1 / \mu}, \eqn{\mu* = 1}, \eqn{A(\mu) = log(\mu)}, name = "beta" and family = Gamma(). Beta-family is highly recommended for general problems and used as default.

Inverse-gaussian family (\code{inv_gaussian_family()}): modeling p-values as transformed z-scores, i.e. \eqn{g(p) = \Phi^{-1}(p) (\Phi is the c.d.f. of a standard normal random variable)}, \eqn{\eta(\mu) = \mu}, \eqn{\mu* = 0}, \eqn{A(\mu) = \mu^2 / 2}, name = "inv_gaussian" and family = gaussian().
}
