% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prob_funs.R
\name{reallocate_probs}
\alias{reallocate_probs}
\title{Update allocation probabilities}
\usage{
reallocate_probs(
  probs_best,
  fixed_probs,
  min_probs,
  max_probs,
  soften_power = 1,
  match_arm = NULL,
  rescale_fixed = FALSE,
  rescale_limits = FALSE,
  rescale_factor = 1,
  rescale_ignore = NULL
)
}
\arguments{
\item{probs_best}{a resulting named vector from the \code{\link[=prob_best]{prob_best()}} function.}

\item{fixed_probs}{numeric vector, fixed allocation probabilities for each
arm. Must be either a numeric vector with \code{NA} for arms without fixed
probabilities and values between \code{0} and \code{1} for the other arms or \code{NULL}
(default), if adaptive randomisation is used for all arms or if one of the
special settings (\code{"sqrt-based"}, \code{"sqrt-based start"},
\code{"sqrt-based fixed"}, or \code{"match"}) is specified for \code{control_prob_fixed}
(described below).}

\item{min_probs}{numeric vector, lower threshold for adaptive allocation
probabilities; lower probabilities will be rounded up to these values. Must
be \code{NA} (default for all arms) if no lower threshold is wanted and for arms
using fixed allocation probabilities.}

\item{max_probs}{numeric vector, upper threshold for adaptive allocation
probabilities; higher probabilities will be rounded down to these values.
Must be \code{NA} (default for all arms) if no threshold is wanted and for arms
using fixed allocation probabilities.}

\item{soften_power}{either a single numeric value or a numeric vector of
exactly the same length as the maximum number of looks/adaptive analyses.
Values must be between \code{0} and \code{1} (default); if \verb{< 1}, then re-allocated
non-fixed allocation probabilities are all raised to this power (followed
by rescaling to sum to \code{1}) to make adaptive allocation probabilities
less extreme, in turn used to redistribute remaining probability while
respecting limits when defined by \code{min_probs} and/or \code{max_probs}. If \code{1},
then no \emph{softening} is applied.}

\item{match_arm}{index of the \code{control} arm. If not \code{NULL} (default), the
control arm allocation probability will be similar to that of the best
non-control arm. Must be \code{NULL} in designs without a common control arm.}

\item{rescale_fixed}{logical indicating whether \code{fixed_probs} should be
rescaled following arm dropping.}

\item{rescale_limits}{logical indicating whether \code{min/max_probs} should be
rescaled following arm dropping.}

\item{rescale_factor}{numerical, rescale factor defined as
\verb{initial number of arms/number of active arms}.}

\item{rescale_ignore}{\code{NULL} or index of an arm that will be ignored by the
\code{rescale_fixed} and \code{rescale_limits} arguments.}
}
\value{
A named (according to the \code{arms}) numeric vector with updated
allocation probabilities.
}
\description{
Used internally. This function calculates new allocation probabilities for
each arm, based on the information specified in \code{\link[=setup_trial]{setup_trial()}},
\code{\link[=setup_trial_binom]{setup_trial_binom()}} or \code{\link[=setup_trial_norm]{setup_trial_norm()}} and the calculated
probabilities of each arm being the best by \code{\link[=prob_best]{prob_best()}}.
}
\keyword{internal}
