% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adbc.R, R/options.R
\name{adbc_connection_init}
\alias{adbc_connection_init}
\alias{adbc_connection_init_default}
\alias{adbc_connection_release}
\alias{adbc_connection_set_options}
\alias{adbc_connection_get_option}
\alias{adbc_connection_get_option_bytes}
\alias{adbc_connection_get_option_int}
\alias{adbc_connection_get_option_double}
\title{Connections}
\usage{
adbc_connection_init(database, ...)

adbc_connection_init_default(database, options = NULL, subclass = character())

adbc_connection_release(connection)

adbc_connection_set_options(connection, options)

adbc_connection_get_option(connection, option)

adbc_connection_get_option_bytes(connection, option)

adbc_connection_get_option_int(connection, option)

adbc_connection_get_option_double(connection, option)
}
\arguments{
\item{database}{An \link[=adbc_database_init]{adbc_database}.}

\item{...}{Driver-specific options. For the default method, these are
named values that are converted to strings.}

\item{options}{A named \code{character()} or \code{list()} whose values are converted
to strings.}

\item{subclass}{An extended class for an object so that drivers can specify
finer-grained control over behaviour at the R level.}

\item{connection}{An \link[=adbc_connection_init]{adbc_connection}}

\item{option}{A specific option name}
}
\value{
An object of class 'adbc_connection'
}
\description{
Connections
}
\examples{
db <- adbc_database_init(adbc_driver_void())
adbc_connection_init(db)

}
