% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bf_sep.R
\name{bf_sep_lh}
\alias{bf_sep_lh}
\title{Baseflow Seperation}
\usage{
bf_sep_lh(discharge, a = 0.98, n = 3, reflect = 30)
}
\arguments{
\item{discharge}{numeric vector of daily discharge values}

\item{a}{alpha, numeric values between \code{[0-1]}.}

\item{n}{number of passes for the filter. Must be a numeric value, defaults
to 3.}

\item{reflect}{the number of values to reflect at the start and end of
\code{discharge} to reduce "warm-up" and "cool-down" issues with the
recursive filter. Must be less than or equal to the length of
\code{discharge}. For long discharge records this value does not matter
much, for short records the reflection should approach the length of
\code{discharge}. The default is 30 as implemented in Ladson et al. (2013).}
}
\value{
vector of numeric values representing estimated baseflow.
}
\description{
Implements the Lyne and Hollick filter for baseflow seperation. This
function utilizes the approach in Ladson et al. (2013).
}
\details{
This function implements the Lyne-Hollick filter (Lyne and Hollick,
1979) using the approach detailed in Ladson et al. (2013). The filter is:

\deqn{Y_{k} = \alpha \times Y_{k-1} + \frac{1+\alpha}{2} \times (Q_k - Q_{k-1}),}

where \eqn{Y_k} is the filtered quick response at the \eqn{k^{th}} sample.
\eqn{Q_k} if the original streamflow and \eqn{\alpha} is the filter
parameter between \code{[0-1]}.

Ladson et al. (2013) suggest a standardized approach for applying the
filter by: (1) reflecting streamflow at the start and end of the series to
address warm-up and cool-down; (2) specify the initial value of each pass
as the measured flow; and (3) using three passes for the filter (forward,
backward, forward); Ladson et al. (2013) also provide additional
suggestions for handling missing values and appropriate alpha parameter
values that are not covered here.
}
\note{
This function an updated and modified version of the \code{baseflows()}
function in the hydrostats package by Nick Bond. The hydrostats version
returns additional summary measures and utilizes different starting values.
Outputs between the two packages will slightly vary.
}
\examples{

bf <- bf_sep_lh(lavaca$Flow, a = 0.975)
head(bf)

}
\references{
Lyne, V., & Hollick, M. (1979, September). Stochastic time-variable
rainfall-runoff modelling. In Institute of Engineers Australia National
Conference (Vol. 79, No. 10, pp. 89-93). Barton, Australia: Institute of
Engineers Australia.

Ladson, A. R., Brown, R., Neal, B., & Nathan, R. (2013). A standard
approach to baseflow separation using the Lyne and Hollick filter.
Australian Journal of Water Resources, 17(1), 25-34,
\doi{10.7158/W12-028.2013.17.1}.
}
\author{
Nick Bond \href{mailto:n.bond@latrobe.edu.au}{n.bond@latrobe.edu.au} modified by Michael Schramm
}
