% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segmentWalking.R
\name{segmentWalking}
\alias{segmentWalking}
\title{Walking Stride Pattern Segmentation from Raw Accelerometry Data via ADEPT}
\usage{
segmentWalking(
  xyz,
  xyz.fs,
  template,
  sim_MIN = 0.85,
  dur_MIN = 0.8,
  dur_MAX = 1.4,
  ptp_r_MIN = 0.2,
  ptp_r_MAX = 2,
  vmc_r_MIN = 0.05,
  vmc_r_MAX = 0.5,
  mean_abs_diff_med_p_MAX = 0.5,
  mean_abs_diff_med_t_MAX = 0.2,
  mean_abs_diff_dur_MAX = 0.2,
  compute.template.idx = FALSE,
  run.parallel = FALSE,
  run.parallel.cores = 1
)
}
\arguments{
\item{xyz}{A numeric matrix (or data frame) of n × 3 dimension.
Three-dimensional
raw accelerometry data time-series; acceleration measurements \code{(x,y,z)}
collected
along three orthogonal axes by the sensor's accelerometer.}

\item{xyz.fs}{A numeric scalar. Frequency at which a time-series
\code{(x,y,z)} is
collected, expressed in a number of observations per second.}

\item{template}{A list of numeric vectors, or a numeric vector. Distinct
pattern template(s) of walking stride.}

\item{sim_MIN}{numeric scalar. Minimum value of correlation between pattern
template(s) and (r_t)_t vector magnitude of accelerometry data.
Default used is 0.85.}

\item{dur_MIN}{A numeric scalar. Minimum value of a stride duration allowed
to be identified. Expressed in seconds. Default used is 0.8.}

\item{dur_MAX}{A numeric scalar. Maximum value of a stride duration allowed
to be identified. Expressed in seconds. Default used is 1.4.}

\item{ptp_r_MIN}{A numeric scalar. Minimum value of "peak to peak"
difference in (r_t)_t vector magnitude data of a stride.
Default used is 0.2.}

\item{ptp_r_MAX}{A numeric scalar. Maximum value of "peak to peak"
difference in (r_t)_t vector magnitude data of a stride.
Default used is 2.0}

\item{vmc_r_MIN}{A numeric scalar. Minimum value of VMC in
(r_t)_t vector magnitude data
of a stride. Default used is 0.05.}

\item{vmc_r_MAX}{A numeric scalar. Maximum value of VMC in
(r_t)_t vector magnitude data
of a stride. Default used is 0.5.}

\item{mean_abs_diff_med_p_MAX}{A numeric scalar. Maximum value of MAD* of
Azimuth (az_)_t median for 3 subsequent valid strides.
Here, MAD* stands for mean
of 2 absolute differences between 3 subsequent values. Default used is 0.5.}

\item{mean_abs_diff_med_t_MAX}{A numeric scalar. Maximum value of MAD* of
Elevation (el_)_t median for 3 subsequent valid strides.
Here, MAD* stands for mean
of 2 absolute differences between 3 subsequent values. Default used is 0.2.}

\item{mean_abs_diff_dur_MAX}{A numeric scalar. Maximum value of MAD* of
duration time for 3 subsequent valid strides. Here, MAD* stands for mean
of 2 absolute differences between 3 subsequent values. Default used is 0.2.}

\item{compute.template.idx}{A logical scalar. Whether or not to compute
and return information about
which of the provided pattern templates yielded a similarity matrix value
that corresponds to an identified pattern occurrence.
Setting to \code{TRUE} may increase computation time.
Default is \code{FALSE}.}

\item{run.parallel}{A logical scalar. Whether or not to use parallel
execution in the algorithm
with \code{parallel} package. Default is \code{FALSE}.
DOES NOT WORK ON WINDOWS.}

\item{run.parallel.cores}{An integer scalar.
The number of cores to use for parallel execution. Defaults to 1L
(no parallel). DOES NOT WORK ON WINDOWS.}
}
\value{
A \code{data.frame} with segmentation results. Each row
describes one identified pattern occurrence:
\itemize{
  \item \code{tau_i} - row index of \code{xyz} where pattern starts,
  \item \code{T_i} - pattern duration, expressed in \code{xyz} vector length,
  \item \code{sim_i} -  similarity between a pattern and
  best-fit template; see \code{segmentPattern} for details,
  \item \code{template_i} - if \code{compute.template.idx} equals \code{TRUE}:
  index of a template best matched to \code{x};
 if \code{compute.template.idx} equals \code{FALSE}: \code{NA},
 \item \code{is_walking_i} -- \code{1} if a pattern is identified as walking
 stride; \code{0} otherwise.
}
}
\description{
Segment walking stride pattern from a raw accelerometry data time-series
\code{(x,y,z)} via Adaptive Empirical Pattern Transformation (ADEPT).
Default algorithm parameters are optimized for a wrist-worn sensor and
were evaluated with data collected in the free-living environment.
}
\examples{
library(adeptdata)
library(dplyr)
library(adept)
xyz <-
  adeptdata::acc_walking_IU \%>\%
  filter(loc_id == "left_wrist", subj_id == "id86237981") \%>\%
  arrange(time_s) \%>\%
  select(v1 = x, v2 = y, v3 = z) \%>\%
  as.matrix()
# define raw accelerometry data sample frequency
xyz.fs <- 100

# define template list based on predefined templates
template_mat <- adeptdata::stride_template$left_wrist[[3]]
template <- list(
  template_mat[1, ],
  template_mat[2, ],
  template_mat[3, ]
)

# run walking segmentation
# (parallel supported, except for Windows; see run.parallel, run.parallel.cores args)
segmentWalking(xyz, xyz.fs, template)

}
