% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot.roc.R
\name{boot.roc}
\alias{boot.roc}
\title{boot.roc}
\usage{
boot.roc(
  score,
  class,
  metric = "AUC",
  n = 100,
  method = "emp",
  event_level = "first"
)
}
\arguments{
\item{score}{A numeric array of diagnostic score i.e. the estimated probability of each diagnosis}

\item{class}{A numeric array of equal length of \code{"score"}, including the
actual class of the observations}

\item{metric}{character. specify the metric of interest which can be
\code{"AUC"} (Area Under the Curve, default) or  \code{"AUCPR"}
(Area Under the Precision-Recall Curve).}

\item{n}{number of bootstrap samples.}

\item{method}{Specifies the method for estimating the ROC curve. Three methods
are supported, which are \code{"empirical"}, \code{"binormal"},
and \code{"nonparametric"}}

\item{event_level}{character. only needed for bootstrapping AUCPR. this
argument specifies which level of the "class" should be
considered the positive event. the values can only be
\code{"first"} or \code{"second"}.}
}
\value{
list including mean and CI of bootstrap value (sensitivity, specificity, or
    the crossing point) and the bootstrap data.
}
\description{
computes bootstrap AUC and AUCPR for the ROC curve
}
\examples{
# random classification and probability score
score <- runif(10000, min=0, max=1)
class <- sample(x = c(1,0), 10000, replace=TRUE)

# calculate bootstrap AUC of the ROC curve
boot.roc(score = score, class = class, n = 100, metric = "AUC")

# calculate bootstrap AUCPR of the ROC curve
boot.roc(score = score, class = class, n = 100, metric = "AUCPR")
}
