% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_CR_data.R
\name{simulate_CR_data}
\alias{simulate_CR_data}
\title{Simulate stratified clustered competing risks data}
\usage{
simulate_CR_data(
  n = 4,
  m = 100,
  alpha = 1,
  beta1 = c(0.7, -0.7, -0.5) * 1/alpha,
  beta2 = c(0.5, -0.5, 1),
  betaC = c(0, 0, 0) * 1/alpha,
  lambdaC = 0.59,
  stratified = TRUE,
  rho = c(2, 4),
  lambdaC0 = c(0.9, 2.5)
)
}
\arguments{
\item{n}{Number of observations in each cluster. Default is 4.}

\item{m}{Total number of clusters. Default is 100.}

\item{alpha}{Parameter for a positive stable distribution. It controls correlation within a cluster. 
\code{1/alpha} must be an integer such that \code{alpha = 0.25, 0.5 and 1}. \code{alpha=1} generates independent data.
As \code{alpha} decreases, the correlation within a cluster increases. Default is 1.}

\item{beta1}{This is a vector of values of length 3. This value multiplied by \code{alpha} is a true covariate 
effect for Cause 1.}

\item{beta2}{This is a vector of values of length 3. It is a true covariate 
effect for Cause 2.}

\item{betaC}{This is a vector of values of length 3. This value multiplied by \code{alpha} is a true covariate 
effect for censoring. A marginal proportional hazards model is used to generate clustered censoring times
based on \cite{Logan et al. (2011)}.}

\item{lambdaC}{Constant baseline hazard for censoring for the marginal proportional hazards model.}

\item{stratified}{It is \code{TRUE} for stratified data. Two strata are considered.
If \code{TRUE}, the remaining parameters must be provided.}

\item{rho}{Baseline hazard for each stratum. Must be a vector of length two.}

\item{lambdaC0}{Constant baseline hazard of censoring for each stratum. Must be a vector of length two.}
}
\value{
Returns a data frame with the following variables:
\item{time}{Survival times}
\item{cause}{Different causes of an event. Censoring is 0. The main cause is 1}
\item{Z1}{Bernoulli distributed covariate with probability 0.6}
\item{Z2}{Standard normal covariate}
\item{Z3}{Uniform distributed covariate}
\item{cluster}{Cluster variable}
\item{strata}{Strata variable. Only if \code{stratified=TRUE}.}
}
\description{
The function \code{simulate_CR_data} simulates stratified competing risks data with two causes based 
on a proportional subdistribution hazard model based on \cite{Logan et al. (2011)}.
Three covariates (Bernoulli, Normal and Uniform) are considered.
}
\examples{
alpha = 0.5

#Simulate unstratified clustered competing risks data
d1 = simulate_CR_data(n=4,m=100,alpha=alpha,beta1=c(0.7,-0.7,-0.5)*1/alpha,beta2=c(0.5,-0.5,1),
betaC=c(0,0,0)*1/alpha,lambdaC=0.59,stratified=FALSE)

#Simulate stratified clustered competing risks data
d2 = simulate_CR_data(n=4,m=100,alpha=alpha,beta1=c(0.7,-0.7,-0.5)*1/alpha,beta2=c(0.5,-0.5,1),
betaC=c(0,0,0)*1/alpha,lambdaC=0.59,stratified=TRUE,rho=c(2,4),lambdaC0=c(0.9,2.5))
}
\references{
{Logan BR, Zhang MJ, Klein JP. Marginal models for clustered time-to-event data with competing risks using pseudovalues. Biometrics. 2011;67(1):1-7. doi:10.1111/j.1541-0420.2010.01416.x}
}
