% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_query_data.R
\name{get_terms_from_db}
\alias{get_terms_from_db}
\title{Get Terms from the Queries Database}
\usage{
get_terms_from_db(
  version,
  fun,
  fun_name,
  queries,
  definition,
  expect_grpname = FALSE,
  expect_grpid = FALSE,
  i,
  temp_env
)
}
\arguments{
\item{version}{Version

The version must be non null. Otherwise, an error is issued. The value is
passed to the access function (\code{fun}).

\describe{
\item{Default value}{none}
}}

\item{fun}{Access function

The access function must be non null. Otherwise, an error is issued. The
function is called to retrieve the terms.

\describe{
\item{Default value}{none}
}}

\item{fun_name}{Name of access function

The character name of the access function, usually created with
\code{deparse(substitute(fun))}. This must be non null. Otherwise, an error is issued.

\describe{
\item{Default value}{none}
}}

\item{queries}{Queries

List of all queries passed to \code{create_query_data()}. It is used for error
messages.

\describe{
\item{Default value}{none}
}}

\item{definition}{Definition of the query

The definition is passed to the access function. It defines which terms are
returned.

\describe{
\item{Default value}{none}
}}

\item{expect_grpname}{Is \code{GRPNAME} expected in the output dataset?

\describe{
\item{Default value}{\code{FALSE}}
}}

\item{expect_grpid}{Is \code{GRPID} expected in the output dataset?

\describe{
\item{Default value}{\code{FALSE}}
}}

\item{i}{Index of \code{definition} in \code{queries}

The value is used for error messages.

\describe{
\item{Default value}{none}
}}

\item{temp_env}{Temporary environment

The value is passed to the access function.

\describe{
\item{Default value}{none}
}}
}
\value{
Output dataset of the access function
}
\description{
The function checks if all requirements to access the database are fulfilled
(version and access function are available, see \code{assert_db_requirements()}),
reads the terms from the database, and checks if the dataset with the terms
is in the expected format (see \code{assert_terms()}).
}
\keyword{internal}
