% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/densub.R
\name{densub}
\alias{densub}
\title{densub}
\usage{
densub(G, m, n, tau = 0.35, gamma = 6/(sqrt(m * n) * (q - p)),
  opt_tol = 1e-04, maxiter, quiet = TRUE)
}
\arguments{
\item{G}{sampled binary matrix}

\item{m}{number of rows in dense submatrix}

\item{n}{number of columns in dense submatrix}

\item{tau}{penalty parameter for equality constraint violation}

\item{gamma}{\eqn{l_1} regularization parameter}

\item{opt_tol}{stopping tolerance in algorithm}

\item{maxiter}{maximum number of iterations of the algorithm to run}

\item{quiet}{toggles between displaying intermediate statistics}
}
\value{
Rank one matrix with \eqn{mn} nonzero entries, matrix \eqn{Y} that is used to count the number of disagreements between \eqn{G} and \eqn{X}
}
\description{
Iteratively solves the convex optimization problem using ADMM.
}
\details{
\eqn{min    |X|_* + gamma* |Y|_1 + 1_Omega_W (W) + 1_Omega_Q (Q) + 1_Omega_Z (Z)}

s.t    \eqn{X - Y = 0}, \eqn{X = W}, \eqn{X = Z},

where \eqn{Omega_W (W)}, \eqn{Omega_Q (Q)}, \eqn{Omega_Z (Z)} are the sets:
      \eqn{Omega_W = {W in R^MxN | e^TWe = mn}}

\eqn{Omega_Q = {Q in R^MxN | Projection of Q on not N = 0}}

\eqn{Omega_Z = {Z in R^MxN | Z_ij <= 1 for all (i,j) in M x N}}

\eqn{Omega_Q = {Q in R^MxN | Projection of Q on not N = 0}}

\eqn{Omega_Z = {Z in R^MxN | Z_ij <= 1 for all (i,j) in M x N}}

\eqn{1_S} is the indicator function of the set \eqn{S} in \eqn{R^MxN} such that \eqn{1_S(X) = 0} if \eqn{X} in \eqn{S} and +infinity otherwise
}
