#Install packages
install.packages("netdiffuseR")
library(netdiffuseR)

#Prepare dataset
#Convert Adjacency List into Adjacency Matrix
list<-read.table("jazz.net", header = FALSE) #Read Jazz dataset
View(list)
list[[3]] <- NULL #Delete 3rd column with weights (all weights are 1)
matrix_jazz<-edgelist_to_adjmat(list,undirected = TRUE)
new<-as.matrix(matrix_jazz)
colnames(new) #check col names
col.order <- c("1","2","3","4","5", "6", "7", "8", "9", "10", "11", "12", "13", "14","15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29",  "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "50", "51", "52", "53", "54", "55", "56", "57", "58", "59", "60", "61", "62", "63", "64", "65", "66", "67", "68", "69", "70", "71", "72","73", "74", "75", "76","77", "78", "79", "80", "81", "82", "83", "84", "85", "86", "87", "88", "89", "90", "91", "92", "93", "94", "95", "96", "97", "98", "99", "100", "101", "102", "103", "104", "105", "106", "107", "108", "109", "110", "111", "112", "113", "114", "115", "116", "117", "118", "119", "120", "121", "122", "123", "124", "125", "126", "127", "128", "129", "130", "131", "132", "133", "134", "135", "136", "137", "138", "139", "140", "141", "142", "143", "144", "145", "146", "147", "148", "149", "150", "151", "152", "153", "154", "155", "156", "157", "158", "159", "160", "161", "162", "163", "164", "165", "166", "167", "168", "169", "170", "171", "172", "173","174", "175", "176", "177", "178", "179", "180", "181", "182", "183", "184", "185", "186", "187", "188", "189", "190", "191", "192", "193", "194", "195", "196", "197", "198")

rownames(new) #check row names
row.order<- c("1","2","3","4","5", "6", "7", "8", "9", "10", "11", "12", "13", "14","15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29",  "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "50", "51", "52", "53", "54", "55", "56", "57", "58", "59", "60", "61", "62", "63", "64", "65", "66", "67", "68", "69", "70", "71", "72","73", "74", "75", "76","77", "78", "79", "80", "81", "82", "83", "84", "85", "86", "87", "88", "89", "90", "91", "92", "93", "94", "95", "96", "97", "98", "99", "100", "101", "102", "103", "104", "105", "106", "107", "108", "109", "110", "111", "112", "113", "114", "115", "116", "117", "118", "119", "120", "121", "122", "123", "124", "125", "126", "127", "128", "129", "130", "131", "132", "133", "134", "135", "136", "137", "138", "139", "140", "141", "142", "143", "144", "145", "146", "147", "148", "149", "150", "151", "152", "153", "154", "155", "156", "157", "158", "159", "160", "161", "162", "163", "164", "165", "166", "167", "168", "169", "170", "171", "172", "173","174", "175", "176", "177", "178", "179", "180", "181", "182", "183", "184", "185", "186", "187", "188", "189", "190", "191", "192", "193", "194", "195", "196", "197", "198")

new<-new[row.order, col.order] #matrix with the right order
save(new, file="JAZZ.RData")#save dataset
load(file="JAZZ.RData") #load dataset


G=jazz
m=100
n=100
tau=0.85
opt_tol=1.0e-2
verbose=1
maxiter=2000
gamma=8/n


admm <- densub(G = G, m = m, n = n, tau = tau, gamma = gamma, opt_tol = opt_tol, maxiter=maxiter, quiet = TRUE)

X0=matrix(0L, nrow=198, ncol=198)
X0[1:100,1:100]=matrix(1L, nrow=100, ncol=100)

Y0=matrix(0L, nrow=198, ncol=198)
Y0[1:100,1:100]=matrix(1L,nrow=100,ncol=1000)-G[1:100,1:100]

C=admm$X-X0
a=norm(C, "F")
b=norm(X0,"F")
recovery = matrix(0L,nrow=1, ncol=1)

if (a/b^2<opt_tol){
  recovery=recovery+1
} else {
  recovery=0
}




