% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_query.R
\name{create_query}
\alias{create_query}
\title{create_query}
\usage{
create_query(customer_id, query_title, query_text, token)
}
\arguments{
\item{customer_id}{ADH Customer ID e.g. customers/123}

\item{query_title}{Query title, which is unique within a single Ads Data Hub customer and query type. e.g.RnF Analysis}

\item{query_text}{Query text written in Standard SQL.}

\item{token}{Access token retrived from function google_auth()}
}
\value{
If successful, the response body contains a newly created instance of the query
}
\description{
Creates an analysis query for later execution. No query validation is performed at this time. Reference: <https://developers.google.com/ads-data-hub/reference/rest/v1/customers.analysisQueries/create>
}
\examples{
\dontrun{
library(adsDataHubR)
token <- google_auth(client_id = client_id, client_secret=client_secret)
create_query(customer_id, query_title, query_text, token)
}
}
