% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_queries.R
\name{list_queries}
\alias{list_queries}
\title{list_queries}
\usage{
list_queries(customer_id, token)
}
\arguments{
\item{customer_id}{ADH Customer ID e.g. customers/123}

\item{token}{Access token retrived from function google_auth()}
}
\value{
A list of analysis queries run on the ADH customer account.
}
\description{
Lists links between the specified customer and other Google advertising entities. Reference: <https://developers.google.com/ads-data-hub/reference/rest/v1/customers.analysisQueries/list>
}
\examples{
\dontrun{
library(adsDataHubR)
token <- google_auth(client_id = client_id, client_secret=client_secret)
total_customers <- get_customers(token)
customer_id <- "customers/123456"
list_queries(customer_id, token)
}
}
