% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc_langmuirLM1.R
\name{mcmc_langmuirLM1}
\alias{mcmc_langmuirLM1}
\title{MCMC Analysis for Langmuir Isotherm Linear (Form 1) Model}
\arguments{
\item{Ce}{Numeric vector of equilibrium concentrations.}

\item{Qe}{Numeric vector of adsorbed amounts.}

\item{burnin}{Integer specifying the number of burn-in iterations (default is 1000).}

\item{mcmc}{Integer specifying the total number of MCMC iterations (default is 5000).}

\item{thin}{Integer specifying the thinning interval (default is 10).}

\item{verbose}{Integer controlling the frequency of progress updates (default is 100).}

\item{plot}{Logical; if TRUE, trace and density plots of the MCMC chains are shown (default is FALSE).}

\item{n_chains}{Number of independent MCMC chains (default = 2).}

\item{seed}{Optional integer for reproducibility.}
}
\value{
A list containing:
\describe{
  \item{mcmc_results}{An object of class \code{mcmc.list} containing posterior samples from all MCMC chains.}
  \item{Qmax_mean}{Posterior mean estimate of (Qmax).}
  \item{b_mean}{Posterior mean estimate of Langmuir constant (b).}
  \item{slope_mean}{Posterior mean of the slope ((1/Qmax)).}
  \item{intercept_mean}{Posterior mean of the intercept ((1/(Qmax*b))).}
  \item{slope_sd}{Posterior standard deviation of the slope.}
  \item{intercept_sd}{Posterior standard deviation of the intercept.}
  \item{slope_ci}{95\% credible interval for the slope.}
  \item{intercept_ci}{95\% credible interval for the intercept.}
  \item{gelman_diag}{Gelman-Rubin convergence diagnostic.}
  \item{mcmc_summary}{Summary statistics of the first MCMC chain.}
}
}
\description{
Performs Bayesian parameter estimation using Markov Chain Monte Carlo (MCMC) to estimate the parameters of the Langmuir isotherm based on its first linear form:
Ce / Qe = 1 / (Qmax * b) + Ce / Qmax
This method provides a probabilistic interpretation of the model parameters and accounts for their uncertainties.
It supports multiple MCMC chains and computes convergence diagnostics (Gelman-Rubin).
}
\examples{
Ce <- c(0.01353, 0.04648, 0.13239, 0.27714, 0.41600, 0.63607, 0.80435, 1.10327, 1.58223)
Qe <- c(0.03409, 0.06025, 0.10622, 0.12842, 0.15299, 0.15379, 0.15735, 0.15735, 0.16607)
mcmc_langmuirLM1(Ce, Qe, burnin = 1000, mcmc = 5000, thin = 10,
                 verbose = 100, plot = TRUE, n_chains = 2, seed = 123)
}
\references{
Gilks, W. R., Richardson, S., & Spiegelhalter, D. J. (1995). \emph{Markov Chain Monte Carlo in Practice}. Chapman and Hall/CRC.
}
\author{
Paul Angelo C. Manlapaz
}
