% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/targeting_idea_service.R
\name{TargetingIdeaService_searchParameters}
\alias{TargetingIdeaService_searchParameters}
\title{TargetingIdeaService - Search Parameter}
\usage{
TargetingIdeaService_searchParameters(categoryProductsAndServices, competition,
  ideaTextFilter_included, ideaTextFilter_excluded, includeAdultContent,
  language, location, network_GoogleSearch, network_SearchNetwork,
  relatedToQuery, relatedToUrl, searchVolumeMinimum, searchVolumeMaximum,
  seedAdGroupId, apiVersion)
}
\arguments{
\item{categoryProductsAndServices}{A keyword category ID (Integer) in the "Products and Services" taxonomy that all search results should belong to.}

\item{competition}{Vector of Levels of competition that should be included in the results}

\item{ideaTextFilter_included}{The vector of strings that should be included}

\item{ideaTextFilter_excluded}{The vector of strings that should be excluded}

\item{includeAdultContent}{TRUE or FALSE option for whether results would include the targeting of Adult Content.}

\item{language}{The Language (or Criterion ID) that all results should be targeted against.}

\item{location}{The Location (or Criterion ID) that all results should be targeted against.}

\item{network_GoogleSearch}{Whether results should be targeting Google Search}

\item{network_SearchNetwork}{Whether results should be targeting the Google Search Network (AFS)}

\item{relatedToQuery}{The vector of queries to post to the API as a Search Parameter.}

\item{relatedToUrl}{The vector of URLs to post to the API, which results will be related to.}

\item{searchVolumeMinimum}{The minimum Search Volume that should be targeted.}

\item{searchVolumeMaximum}{The maximum Search Volume that should be targeted.}

\item{seedAdGroupId}{The Adgroup ID that should be used as a seed for generating new ideas.}

\item{apiVersion}{The version of the API}
}
\value{
Returns the XML text for all of the requested Search Parameters
}
\description{
TargetingIdeaService.SeedAdGroupIdSearchParameter
}
\references{
Documentation content adapted from \href{https://developers.google.com/adwords/api/docs/reference/v201802/TargetingIdeaService.SearchParameter}{Google Adwords API documentation} under license from \href{https://creativecommons.org/licenses/by/3.0/}{CC BY 3.0}
}
