% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/affine.r
\name{transform2d}
\alias{transform2d}
\alias{permute2d}
\alias{project2d}
\alias{reflect2d}
\alias{rotate2d}
\alias{scale2d}
\alias{shear2d}
\alias{translate2d}
\title{2D affine transformation matrices}
\usage{
transform2d(mat = diag(3L))

permute2d(permutation = c("xy", "yx"))

project2d(line = as_line2d("x-axis"), ..., scale = 0)

reflect2d(line = as_line2d("x-axis"), ...)

rotate2d(theta = angle(0), ...)

scale2d(x_scale = 1, y_scale = x_scale)

shear2d(xy_shear = 0, yx_shear = 0)

translate2d(x = as_coord2d(0, 0), ...)
}
\arguments{
\item{mat}{A 3x3 matrix representing a post-multiplied affine transformation matrix.
The last \strong{column} must be equal to \code{c(0, 0, 1)}.
If the last \strong{row} is \code{c(0, 0, 1)} you may need to transpose it
to convert it from a pre-multiplied affine transformation matrix to a post-multiplied one.
If a 2x2 matrix (such as a 2x2 post-multiplied 2D rotation matrix)
we'll quietly add a final column/row equal to \code{c(0, 0, 1)}.}

\item{permutation}{Either "xy" (no permutation) or "yx" (permute x and y axes)}

\item{line}{A \link{Line2D} object of length one representing the line
you with to reflect across or project to or an object coercible to one by \code{as_line2d(line, ...)}
such as "x-axis" or "y-axis".}

\item{...}{Passed to \code{\link[=as_angle]{as_angle()}} or \code{\link[=as_coord2d]{as_coord2d()}}.}

\item{scale}{Oblique projection scale factor.
A degenerate \code{0} value indicates an orthogonal projection.}

\item{theta}{An \code{\link[=angle]{angle()}} object of length one or an object coercible to one by \code{as_angle(theta, ...)}.}

\item{x_scale}{Scaling factor to apply to x coordinates}

\item{y_scale}{Scaling factor to apply to y coordinates}

\item{xy_shear}{Horizontal shear factor: \code{x = x + xy_shear * y}}

\item{yx_shear}{Vertical shear factor: \code{y = yx_shear * x + y}}

\item{x}{A \link{Coord2D} object of length one or an object coercible to one by \code{as_coord2d(x, ...)}.}
}
\value{
A 3x3 post-multiplied affine transformation matrix with classes "transform2d" and "at_matrix"
}
\description{
\code{transform2d()}, \code{project2d()}, \code{reflect2d()}, \code{rotate2d()}, \code{scale2d()}, \code{shear2d()},
and \code{translate2d()} create 2D affine transformation matrix objects.
}
\details{
\describe{
\item{\code{transform2d()}}{User supplied (post-multiplied) affine transformation matrix}.
\item{\code{project2d()}}{Oblique vector projections onto a line parameterized by
an oblique projection scale factor.
A (degenerate) scale factor of zero results in an orthogonal projection.}
\item{\code{reflect2d()}}{Reflections across a line.
To "flip" across both the x-axis and the y-axis use \code{scale2d(-1)}.}
\item{\code{rotate2d()}}{Rotations around the origin parameterized by an \code{\link[=angle]{angle()}}.}
\item{\code{scale2d()}}{Scale the x-coordinates and/or the y-coordinates by multiplicative scale factors.}
\item{\code{shear2d()}}{Shear the x-coordinates and/or the y-coordinates using shear factors.}
\item{\code{translate2d()}}{Translate the coordinates by a \link{Coord2D} class object parameter.}
}

\code{transform2d()} 2D affine transformation matrix objects are meant to be
post-multiplied and therefore should \strong{not} be multiplied in reverse order.
Note the \link{Coord2D} class object methods auto-pre-multiply affine transformations
when "method chaining" so pre-multiplying affine transformation matrices
to do a single cumulative transformation instead of a method chain of multiple transformations
will not improve performance as much as as it does in other R packages.

To convert a pre-multiplied 2D affine transformation matrix to a post-multiplied one
simply compute its transpose using \code{\link[=t]{t()}}.  To get an inverse transformation matrix
from an existing transformation matrix that does the opposite transformations
simply compute its inverse using \code{\link[=solve]{solve()}}.
}
\examples{
p <- as_coord2d(x = sample(1:10, 3), y = sample(1:10, 3))

# {affiner} affine transformation matrices are post-multiplied
# and therefore should **not** go in reverse order
mat <- transform2d(diag(3)) \%*\%
         reflect2d(as_coord2d(-1, 1)) \%*\%
         rotate2d(90, "degrees") \%*\%
         scale2d(1, 2) \%*\%
         shear2d(0.5, 0.5) \%*\%
         translate2d(x = -1, y = -1)
p1 <- p$
  clone()$
  transform(mat)

# The equivalent result appyling affine transformations via method chaining
p2 <- p$
  clone()$
  transform(diag(3L))$
  reflect(as_coord2d(-1, 1))$
  rotate(90, "degrees")$
  scale(1, 2)$
  shear(0.5, 0.5)$
  translate(x = -1, y = -1)

all.equal(p1, p2)

}
