% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/afmReadJPK.R
\name{afmReadJPK}
\alias{afmReadJPK}
\title{Read Nanowizard JPK ascii file}
\usage{
afmReadJPK(
  filename,
  path = "",
  FColStr = "Vertical",
  ZColStr = "Height (measured)",
  tColStr = "Segment Time",
  silent = FALSE
)
}
\arguments{
\item{filename}{String with the name of the jpk file.}

\item{path}{Path to the folder where the file is.}

\item{FColStr}{String with a pattern identifying the Force column.}

\item{ZColStr}{String with a pattern identifying the Z column.}

\item{tColStr}{String with a pattern identifying the Time column.}

\item{silent}{Logical parameter. If TRUE it suppresses the messages regarding the loading of the JPK file (defaults to FALSE).}
}
\value{
A afmdata structure list containing a field 'data' which is a data frame with 
variables Force, Z, Time (if aplicable) and Segment ("approach", "retract" and/or "pause") and 
a field 'params' which is a list with the fields 'curvename' and 'SpringConstant'.
}
\description{
Read an ascii JPK file.

Reads an ascii JPK file with one to three headers.
}
\examples{
data <- afmReadJPK("force-save-JPK-3h.txt.gz",path = path.package("afmToolkit"))
str(data)
}
