% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/afmRelax.R
\name{afmRelax}
\alias{afmRelax}
\title{Stress relaxation/ Creep model fit}
\usage{
afmRelax(afmdata, model = c("power","exp"), nexp = 2, tmax = NULL, 
       type = c("CH","CF"), plt = TRUE, ...)
}
\arguments{
\item{afmdata}{An object of \code{afmdata} class with a \bold{pause} segment and a
\bold{Time} column in the \code{data} dataframe.}

\item{model}{Type of model to be fitted. Could be either "power" for a power 
law model or "exp" for an exponential decay model.}

\item{nexp}{Number of expontials in the Prony series to be fitted if \code{model} is \code{"exp"}. 
Currently only one or two exponentials are supported. Default is 2.}

\item{tmax}{Maximum time considered in the relaxation curve. It defaults to \code{Inf},
meaning that the whole pause segment is considered.}

\item{type}{Type of the experiment. Can be either "CH" (Constant Height) for a
force-relaxation experiment or "CF" (Constant Force) for a creep experiment. Default
is \code{type = "CH"}.}

\item{plt}{Logical. If TRUE (default) then a plot of the pause segment with the overlay
of the fit is shown.}

\item{...}{Options passed to the \code{nlsM()} function from the \code{minpack.lm}
package. At least should contain the starting values (\code{start = list(...)}) for
the Levenberg-Mardquart nonlinear least square method. For use only if \code{model} is \code{"exp"}.}
}
\value{
An \code{afmdata} class variable which will consist on the original input
  \code{afmdata} variable plus a new list named \code{RelaxFit} with the following
  fields:
  
  \code{model}: The model used in the fit.
  
  \code{relaxModel}: A nls object returned from  \code{nlsM()} function.
  
  \code{relaxFit}: The values predicted by the fit, returned from the 
  \code{predict()} function.
}
\description{
Fits a viscoelastic exponential decay in a Force-Relaxation or Creep
  experiments as described in Nanotechnology 2010 (see references).
}
\examples{
data <- afmReadJPK("force-save-JPK-3h.txt.gz", path = path.package("afmToolkit"))
width <- 20
mul1 <- 1
mul2 <- 10
data <- afmContactPoint(data, width = width, mul1 = mul1, mul2 = mul2)
data <- afmDetachPoint(data, width = width, mul1 = mul1, mul2 = mul2)
data <- afmBaselineCorrection(data)
data <- afmRelax(data, model = "exp", nexp = 2, type = "CH")
}
\references{
Susana Moreno-Flores, Rafael Benitez, Maria dM Vivanco and Jose Luis 
Toca-Herrera (2010). "Stress relaxation and creep on living cells with the atomic force
microscope: a means to calculate elastic moduli and viscosities of cell components".
Nanotechnology, \strong{21} (44), pp. 445101.
}
