% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.afmdata.R
\name{plot.afmdata}
\alias{plot.afmdata}
\title{Plot an afmdata object}
\usage{
\method{plot}{afmdata}(x, y = NULL, vs = "Z", segment = "all", ...)
}
\arguments{
\item{x}{An object of \code{afmdata} class.}

\item{y}{Variable added for compatibility with \code{plot}.}

\item{vs}{The variable for the x-axis. May take the values "Time" or "Z". It defaults
to "Z", plotting thus a Force-Distance curve. If \code{vs} is set to "Time", then it
plots  a Force-Time curve.}

\item{segment}{The segment of the curve to be plotted. If \code{segment = "all"} then
all segments of the curve are plotted. Possible values are: \code{"approach"},
\code{"pause"}, \code{"retract"} and \code{"all"}.}

\item{...}{Additional parameters to be pased to the ggplot functions.}
}
\description{
Plots an afmdata object.
}
\examples{
# Loading the data
path <- path.package("afmToolkit")
data <- afmReadJPK("force-save-JPK-3h.txt.gz", path = path)
# Standard plot (out of the box)
plot(data)
# Computing the contact and detach points
data <- afmContactPoint(data, width = 20, mul1 = 1, mul2 = 10)
data <- afmDetachPoint(data, width = 40, mul1 = 3, mul2 = 20)
# Making the baseline correction
data <- afmBaselineCorrection(data)
# Plot once the baseline correction is done
plot(data)
# Plotting only retract segment
plot(data, segment = "retract")
# Plotting the pause segment: Force vs Time
plot(data, segment = "pause", vs = "Time")
}
