afm_char_to_int <- function(c_v) {
  base::suppressWarnings(as.integer(c_v))
}

pow_2_mult <- function(iv) {
  iv * c(256L, 128L, 64L, 32L, 16L, 8L, 4L, 2L)
}

afm_compute_checksum <- function(v) {
  char_v_l <- base::strsplit(v, split = "")
  int_v_l <- base::lapply(char_v_l, afm_char_to_int)
  pow2_l <- base::lapply(int_v_l, pow_2_mult)
  sum_digits_v <- base::vapply(pow2_l, FUN = sum, FUN.VALUE = NA_integer_)
  check_digit_v <- (sum_digits_v %% 11L) %% 10L
  as.character(check_digit_v)
}

afm_has_correct_checksum <- function(v) {
  afm_compute_checksum(substr(v, 1L, 8L)) == substr(v, 9L, 9L)
}

#' Check validity of AFM
#'
#' Given a character vector, for each of its elements,
#' check the validity of the Greek Tax Identification Number (AFM).
#'
#' @param v a character vector for whose elements validity of AFM
#'   is checked.
#'
#' @return A logical vector.
#'
#' @examples
#' afm_check("BADAFM999")
#' afm_check("123456789")
#' afm_check("12345678")
#' afm_check("123456783")
#' afm_check(c("123456789", "111111116"))
#'
#' @export
afm_check <- function(v) {
  !is.na(v) &
    base::nchar(v) == 9L &
    grepl("^[0-9]{9}$", v) &
    afm_has_correct_checksum(v)
}
