% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aftsem_control.R
\name{aftsem.control}
\alias{aftsem.control}
\title{Control list for package}
\usage{
aftsem.control(
  eps = 10^-5,
  maxiter = 15,
  gehan_eps = 10^-6,
  optimx.alg = "BFGS",
  variance.estimation = FALSE,
  quantile.method = "br",
  use.grad = FALSE
)
}
\arguments{
\item{eps}{Convergence criterion}

\item{maxiter}{Maximum iterations for algorithms}

\item{gehan_eps}{Epsilon value for polynomial Gehan optimalization}

\item{optimx.alg}{Algorithm that will be used in optimx minimalization (see optimx documentation for more details)}

\item{variance.estimation}{If hellers sd will be estimated}

\item{quantile.method}{Method used for quantile regression minimalization}

\item{use.grad}{If excact gradient will be used instead of the numerical one, default is numerical == FALSE}
}
\value{
list of parameters above
}
\description{
Control list for package
}
\note{
When alternating the control list, one must write other variables also. Example: When user want to estimate the Hellers covariance matrix he would need
to change the control list -> aftsem(....., control = list(variance.estimation = TRUE, use.grad = FALSE, optimx.alg = "BFGS))
}
