% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download.R
\name{ag5_download}
\alias{ag5_download}
\title{Downloads AgERA5 data from the Copernicus Climate Change Service - Copernicus Climate Data Store}
\usage{
ag5_download(
  variable,
  statistic = NULL,
  year,
  month,
  day,
  time = NULL,
  version = "1_1",
  path
)
}
\arguments{
\item{variable}{character The variable to be downloaded. See details}

\item{statistic}{character Only required for some variables. See details for options.}

\item{year}{numeric (Integer) Year to download. Should be between 1979 - 2022}

\item{month}{numeric Month to be requested. Use \code{month = "all"}  download
all the months for the requested year.}

\item{day}{numeric Days of the month for the requested data.
Use \code{day = "all"}  to download all days from requested month}

\item{time}{Character Only required for "2m_relative_humidity".}

\item{version}{Character Version 1_1 is currently the default and recommended
See details for available options.}

\item{path}{Character Target folder in an local hardrive e.g. "C:/agera5".
The folder should exist and the user should have write permission.}
}
\value{
No return value, called for side effects.
}
\description{
The data is downloaded from Copernicus Climate Change Service (C3S) using the
Copernicus Climate Data Store (CDSAPI) Python library
\url{https://github.com/ecmwf/cdsapi}

This function  provides programmatic access to the AgERA5 dataset.
For more information about the data license, please visit:
\url{https://cds.climate.copernicus.eu/api/v2/terms/static/licence-to-use-copernicus-products.pdf}

To download the data you should have a valid CDS account,
an CDS API key. Please follow the instructions at: \url{https://cds.climate.copernicus.eu/api-how-to}
to create a file to store your API key. You do not need to install Python or the cdsapi, Ag5Tools
will do it if required.
}
\section{AgERA5 variables available for download:}{
\itemize{
\item cloud_cover
\item liquid_precipitation_duration_fraction
\item snow_thickness_lwe
\item solar_radiation_flux
\item 2m_temperature
\item 2m_dewpoint_temperature
\item precipitation_flux
\item solid_precipitation_duration_fraction
\item snow_thickness
\item vapour_pressure
\item 10m_wind_speed
\item 2m_relative_humidity
}
}

\section{Statistics for variable "2m_temperature"}{
Variable "2m_temperature" requires to indicate at least one of the following
options in \code{statistic}:
\itemize{
\item 24_hour_maximum
\item 24_hour_mean
\item 24_hour_minimum
\item day_time_maximum
\item day_time_mean
\item night_time_mean
\item night_time_minimum
}
}

\section{Parameter "time" for Variable "2m_relative_humidity"}{
Variable "2m_relative_humidity" requires to indicate one of the following
options in \code{time}:
\itemize{
\item 06_00
\item 09_00
\item 12_00
\item 15_00
\item 18_00
}
}

\section{Variables that require statistic}{
For the following variables, only "24_hour_mean" statistic is available, but should
be explicitly indicated.
\itemize{
\item cloud_cover
\item snow_thickness_lwe
\item 2m_dewpoint_temperature
\item snow_thickness
\item vapour_pressure
\item 10m_wind_speed
}
}

\examples{
\dontrun{
ag5_download(variable = "2m_temperature",
            statistic = "night_time_minimum",
            day = "all",
            month = "all",
            year = 2015,
            path = "C:/custom_target_folder"
            )
            }

}
