% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02-normalization.R
\name{nested_quadrature}
\alias{nested_quadrature}
\alias{adaptive_nested_quadrature}
\alias{get_quadtable}
\title{Nested, sparse Gaussian quadrature in AGHQ}
\usage{
nested_quadrature(optresults, k, ndConstruction = "product", ...)

adaptive_nested_quadrature(optresults, k, ndConstruction = "product", ...)

get_quadtable(p, k, ndConstruction = "product", ...)
}
\arguments{
\item{optresults}{The results of calling \code{aghq::optimize_theta()}: see return value of that function.
The dimension of the parameter \code{p} will be taken from \code{optresults$mode}.}

\item{k}{Integer, the number of quadrature points to use.}

\item{ndConstruction}{Create a multivariate grid using a product or sparse construction?
Passed directly to \code{mvQuad::createNIGrid()}, see that function for further details.}

\item{...}{Additional arguments to be passed to \code{optresults$ff}, see \code{?optimize_theta}.}

\item{p}{Dimension of the variable of integration.}
}
\value{
For \code{get_quadtable}, a pre-computed table of nodes for the \code{k}-point rule,
with weights for the points from each of the \code{1,3,...,k}-point rules, for passing to
\code{nested_quadrature}. For \code{nested_quadrature} and \code{adaptive_nested_quadrature}, a named numeric vector of \code{optresults$fn}
values for each \code{k}.
}
\description{
Compute a whole sequence of log normalizing constants
for \code{1,3,5,...,k} points,
using only the function evaluations from the \code{k}-point nested rule.
}
\details{
\code{get_quadtable} currently uses \code{mvQuad} to compute the nodes and weights. This will be replaced
by a manual reading of the pre-tabulated nodes and weights.

\code{nested_quadrature} and \code{adaptive_nested_quadrature} take the \strong{log} function values, just like \code{optimize_theta()},
and return the \strong{log} of the base/adapted quadrature rule.
}
\examples{
# Same setup as optimize_theta
logfteta <- function(eta,y) {
  sum(y) * eta - (length(y) + 1) * exp(eta) - sum(lgamma(y+1)) + eta
}
set.seed(84343124)
y <- rpois(10,5) # Mode should be sum(y) / (10 + 1)
truemode <- log((sum(y) + 1)/(length(y) + 1))
objfunc <- function(x) logfteta(x,y)
funlist <- list(
  fn = objfunc,
  gr = function(x) numDeriv::grad(objfunc,x),
  he = function(x) numDeriv::hessian(objfunc,x)
)
opt_sparsetrust <- optimize_theta(funlist,1.5)

}
\seealso{
Other quadrature: 
\code{\link{aghq}()},
\code{\link{get_hessian}()},
\code{\link{get_log_normconst}()},
\code{\link{get_mode}()},
\code{\link{get_nodesandweights}()},
\code{\link{get_numquadpoints}()},
\code{\link{get_opt_results}()},
\code{\link{get_param_dim}()},
\code{\link{laplace_approximation}()},
\code{\link{marginal_laplace_tmb}()},
\code{\link{marginal_laplace}()},
\code{\link{normalize_logpost}()},
\code{\link{optimize_theta}()},
\code{\link{plot.aghq}()},
\code{\link{print.aghqsummary}()},
\code{\link{print.aghq}()},
\code{\link{print.laplacesummary}()},
\code{\link{print.laplace}()},
\code{\link{print.marginallaplacesummary}()},
\code{\link{summary.aghq}()},
\code{\link{summary.laplace}()},
\code{\link{summary.marginallaplace}()}
}
\concept{quadrature}
