% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stability.cv.R
\name{stability.cv}
\alias{stability.cv}
\title{Coefficient of variation}
\usage{
stability.cv(dataf, res_var, gen_var, env_var, rep_var, plotIt = TRUE)
}
\arguments{
\item{dataf}{the name of the data frame containing the data to analyze.}

\item{res_var}{the response variable.}

\item{gen_var}{the genotypes variable.}

\item{env_var}{the environments variable.}

\item{rep_var}{the replications variable.}

\item{plotIt}{a logical value specifying if plot should be drawn; default is TRUE}
}
\value{
Returns a data frame:
\describe{
  \item{CV}{the genotype's coefficient of variation}
  \item{Mean}{the genotype's mean}
}
}
\description{
This function calculates the Francis&Kannenberg's parameters of stability
}
\examples{
data(exp_data)
stability.cv(exp_data,"yield","gen","env","rep")
}
\references{
Francis, T.R. and L.W. Kannenberg. 1978. Yield stability studies in short-season maize. I. A descriptive method for grouping genotypes. Can J Plant Sci 58: 1029?1034. doi: 10.4141/cjps78-157
}
