% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/def_ParameterDefinitions.R
\name{get_param_dict}
\alias{get_param_dict}
\title{Get dictionary of all parameters}
\usage{
get_param_dict()
}
\value{
Returns a  named \code{list}. The names correspond to specific arguments.
The \code{list} contains a \code{list} for every argument with the following components:
\itemize{
\item type: The type of allowed values.
\item allow_null: A \code{bool} indicating if the argument can be set to \code{NULL}.
\item min: The minimal value the argument can be. Set to \code{NULL} if not relevant. Set to \code{-Inf} if there is no minimum.
\item max: The maximal value the argument can be. Set to \code{NULL} if not relevant. Set to \code{Inf} if there is no Minimum.
\item desc: A \code{string} which includes the description of the argument written in markdown. This string is for the documentation the parameter.
\item values_desc: A named \code{list} containing a description of every possible value. The names must exactly match the strings in allowed_values. Descriptions should be written in markdown.
\item allowed_values: \code{vector} of allowed values. This is only relevant if the argument is not numeric. During the checking of the arguments
it is checked if the provided values can be found in this vector. If all values are allowed set to \code{NULL}.
\item default_value: The default value of the argument. If there is no default set to \code{NULL}.
\item default_historic: Historic default value. This can be necessary for backward compatibility.
\item gui_box: \code{string} Name of the box in AI for Education - Studio where the argument appears. If it should not appear set to \code{NULL}.
\item gui_label: \code{string} Label of the controlling widget in AI for Education - Studio.
}
}
\description{
Function provides a \code{list} containing important characteristics
of the parameter used in the models. The \code{list} does contain only the definition of
arguments for transformer models and all classifiers. The arguments of other functions
in this package are documented separately.

The aim of this list is to automatize argument checking and widget generation for
\emph{AI for Education - Studio}.
}
\seealso{
Other Parameter Dictionary: 
\code{\link{BaseModelsIndex}},
\code{\link{DataSetsIndex}},
\code{\link{TokenizerIndex}},
\code{\link{doc_formula}()},
\code{\link{get_TEClassifiers_class_names}()},
\code{\link{get_called_args}()},
\code{\link{get_depr_obj_names}()},
\code{\link{get_magnitude_values}()},
\code{\link{get_param_def}()},
\code{\link{get_param_doc_desc}()}
}
\concept{Parameter Dictionary}
