% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_to_imeca.R
\name{convert_to_imeca}
\alias{convert_to_imeca}
\title{Convert pollution values to IMECA}
\usage{
convert_to_imeca(value, pollutant, showWarnings = TRUE)
}
\arguments{
\item{value}{a numeric vector of values to convert to IMECAs. Note that the
concentration of pollutants can be measured in different ways, for NO2, and
O3 a 1 hour average is used, for CO, an 8 hour average, and for SO2, PM10
and PM25 a 24 hour average is used.}

\item{pollutant}{type of pollutant. A vector of one or more of the following
options: \itemize{ \item SO2 - Sulfur Dioxide - ppb (24 hour average)
\item CO - Carbon Monoxide - ppm (8 hour average) \item NO2 - Nitrogen
Dioxide - pbb (1 hour average) \item O3 - Ozone ppb (1 hour average)
\item PM10 - Particulate matter 10 micrometers or less (24 hour
average) \item PM25 - Particulate matter 2.5 micrometers or less (24
hour average) }}

\item{showWarnings}{deprecated; you can use the function
\code{\link[base]{suppressWarnings}} instead.}
}
\value{
A vector containing the converted value in IMECAs
}
\description{
This function converts pollution running averages in the original
units (ppb, µg/m³, etc) to
\href{https://en.wikipedia.org/wiki/Índice_Metropolitano_de_la_Calidad_del_Aire}{IMECA}
}
\details{
Air quality in Mexico City is reported in IMECAs (Índice Metropolitano de la
Calidad del Aire), a dimensionless scale where all pollutants can be
compared.

Note that each pollutant has different averaging periods (see the arguments
section). Because of rounding error results may be off by a couple of points.
}
\examples{
## IMECA is a dimensionless scale that allows for the comparison of
## different pollutants
convert_to_imeca(157, "O3")
convert_to_imeca(c(450, 350, 250), rep("NO2", 3))
## Since this is PM10 the 80 is supposed to be the 24 hour average
convert_to_imeca(80, "PM10")

## warning about recycling elements in a vector
convert_to_imeca(c(157, 200), c("O3", "O3"))

convert_to_imeca(67, "O3")
convert_to_imeca(77, "O3")
convert_to_imeca(205, "O3")
convert_to_imeca(72, "O3")
convert_to_imeca(98, "O3")

}
\seealso{
For the formulas on how to convert visit:
  \href{http://www.aire.cdmx.gob.mx/descargas/monitoreo/normatividad/NADF-009-AIRE-2017.pdf}{AVISO POR EL QUE SE DA A CONOCER EL PROYECTO DE NORMA AMBIENTAL PARA EL DISTRITO FEDERAL}

Other convert functions: 
\code{\link{convert_to_index}()}
}
\concept{convert functions}
