% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_goodness_crm.R
\name{model_goodness_crm}
\alias{model_goodness_crm}
\alias{autoplot.modelgoodnesscrm}
\title{Computes the goodness of IRT model for all algorithms.}
\usage{
model_goodness_crm(model)

\method{autoplot}{modelgoodnesscrm}(object, ...)
}
\arguments{
\item{model}{The output of function cirtmodel.}

\item{object}{For autoplot: The output of model_goodness_crm.}

\item{...}{Other arguments currently ignored.}
}
\value{
A list with the following components:
\item{\code{goodnessAUC}}{The area under the model goodness curve for each algorithm. }
\item{\code{curves}}{The \code{x,y} coordinates for the model goodness curves for each algorithm. }
\item{\code{residuals}}{The residuals for each algorithm using the AIRT model.}
}
\description{
This function computes the goodness of the IRT model for all algorithms for different goodness tolerances.
}
\examples{
\donttest{
set.seed(1)
x1 <- runif(200)
x2 <- 2*x1 + rnorm(200, mean=0, sd=0.1)
x3 <- 1 - x1 + rnorm(200, mean=0, sd=0.1)
X <- cbind.data.frame(x1, x2, x3)
mod <- cirtmodel(X)
out <- model_goodness_crm(mod)
out
autoplot(out)
}
}
