% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_goodness_crm.R
\name{model_goodness_for_algo_crm}
\alias{model_goodness_for_algo_crm}
\title{Computes the goodness of IRT model for a given algorithm.}
\usage{
model_goodness_for_algo_crm(mod, num = 1)
}
\arguments{
\item{mod}{A fitted \code{mirt} model using the function \code{irtmodel} or \code{R} package \code{mirt}.}

\item{num}{The algorithm number, for which the goodness of the IRT model is computed.}
}
\value{
A list with the following components:
\item{\code{xy}}{The \code{x} values denote the goodness tolerances. The \code{y} values denote the model goodness. }
\item{\code{auc}}{The area under the model goodness curve. }
\item{\code{residuals}}{The different between actual and fitted performance values.}
}
\description{
This function computes the goodness of the IRT model for a given algorithm for different goodness tolerances.
}
\examples{
\donttest{
set.seed(1)
x1 <- runif(100)
x2 <- runif(100)
x3 <- runif(100)
X <- cbind.data.frame(x1, x2, x3)
max_item <- rep(1,3)
min_item <- rep(0,3)
mod <- cirtmodel(X, max.item=max_item, min.item=min_item)
out <- model_goodness_for_algo_crm(mod$model, num=1)
out
}

}
