% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/snc.R
\name{plot_snc}
\alias{plot_snc}
\title{Plot an introduction record and the fitted model values}
\usage{
plot_snc(object, cumulative = FALSE)
}
\arguments{
\item{object}{an object of class "snc", usually a result of a call to \code{snc}}

\item{cumulative}{logical - should plot be annual or cumulative number of IAS.}
}
\value{
A \code{ggplot} plot with the corresponding type of plot.
}
\description{
Plot an introduction record and the fitted model values
}
\examples{
\donttest{
data(sfestuary)
example_model <- snc(sfestuary)
plot_snc(example_model, cumulative = TRUE)
}
}
