% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/baseline.R
\docType{methods}
\name{baseline_peakfilling}
\alias{baseline_peakfilling}
\alias{baseline_peakfilling-method}
\alias{baseline_peakfilling,numeric,numeric-method}
\alias{baseline_peakfilling,ANY,missing-method}
\title{4S Peak Filling}
\usage{
baseline_peakfilling(x, y, ...)

\S4method{baseline_peakfilling}{numeric,numeric}(x, y, n, m, by = 10, lambda = 1600, d = 2, sparse = FALSE)

\S4method{baseline_peakfilling}{ANY,missing}(x, n, m, by = 10, lambda = 1600, d = 2, sparse = FALSE)
}
\arguments{
\item{x, y}{A \code{\link{numeric}} vector. If \code{y} is missing, an attempt is made to
interpret \code{x} in a suitable way (see \code{\link[grDevices:xy.coords]{grDevices::xy.coords()}}).}

\item{...}{Currently not used.}

\item{n}{An \code{\link{integer}} value giving the number of iterations.}

\item{m}{An odd \code{\link{integer}} giving the half window size.}

\item{by}{A length-one \code{\link{numeric}} vector giving the umber of buckets to
divide \code{x} into.}

\item{lambda}{An \code{\link{integer}} giving the smoothing parameter. The larger
\code{lambda} is, the smoother the curve (see \code{\link[=smooth_whittaker]{smooth_whittaker()}}).}

\item{d}{An \code{\link{integer}} specifying the order of the penalty (see
\code{\link[=smooth_whittaker]{smooth_whittaker()}}).}

\item{sparse}{A \code{\link{logical}} scalar: should sparse matrices be used for
computation (see \code{\link[=smooth_whittaker]{smooth_whittaker()}})? If \code{TRUE}, \pkg{Matrix} is required.}
}
\value{
Returns a \code{\link{list}} with two components \code{x} and \code{y}.
}
\description{
Baseline estimation by iterative mean suppression.
}
\examples{
## X-ray diffraction
data("XRD")

## 4S Peak Filling baseline
baseline <- baseline_peakfilling(XRD, n = 10, m = 5, by = 10, sparse = TRUE)

plot(XRD, type = "l", xlab = expression(2*theta), ylab = "Count")
lines(baseline, type = "l", col = "red")
}
\references{
Liland, K. H. (2015). 4S Peak Filling - baseline estimation by iterative
mean suppression. \emph{MethodsX}, 2, 135-140. \doi{10.1016/j.mex.2015.02.009}.
}
\seealso{
\code{\link[=signal_correct]{signal_correct()}}, \code{\link[=smooth_whittaker]{smooth_whittaker()}}

Other baseline estimation methods: 
\code{\link{baseline_asls}()},
\code{\link{baseline_linear}()},
\code{\link{baseline_polynomial}()},
\code{\link{baseline_rollingball}()},
\code{\link{baseline_rubberband}()},
\code{\link{baseline_snip}()}
}
\author{
N. Frerebeau
}
\concept{baseline estimation methods}
