% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_cohorts.R
\name{compare_cohorts}
\alias{compare_cohorts}
\title{Plot summarized maintenance therapy (MT) data to compare two or more cohorts}
\usage{
compare_cohorts(
  input_files_path,
  unit,
  anc_range,
  dose_intensity_threshold,
  method,
  intervention_date,
  group_data_path
)
}
\arguments{
\item{input_files_path}{Path to folder with MT csv files (in quotes)}

\item{unit}{Choose either "million" or "billion".
\itemize{
\item{"million" = million cells/L (x\eqn{10^{6}} cells/L or cells/\eqn{\mu}l)}
\item{"billion" = billion cells/L (x\eqn{10^{9}} cells/L or x\eqn{10^{3}} cells/\eqn{\mu}l)}
}}

\item{anc_range}{Vector with lower and upper thresholds of absolute neutrophil count target range: (c(lower threshold, upper threshold))
\itemize{
\item{Ensure units of anc_range and patient data (unit) match.}
}}

\item{dose_intensity_threshold}{numeric value of reference drug dose intensity (\%).}

\item{method}{Choose from "M1" or "M2".
\itemize{
\item{"M1"} {= Comparison of cohorts that started MT therapy before or after a particular date of intervention (intervention_date).}
\item{"M2"} {= Comparison of MT therapy between pre-determined groups.}
}}

\item{intervention_date}{Only applicable if method = "M1". Provide date in yyyy-mm-dd format (in quotes)}

\item{group_data_path}{Only applicable for method = "M2". Path to EXCEL FILE containing "group" information.
Ensure "ID" and "Group" columns are present.}
}
\value{
Comparative summary graph
}
\description{
Create an integrated summary graph facetted (by cohort). Graph illustrates
weighted mean absolute neutrophil count (ANC) and dose information for each patient.
}
\note{
\itemize{
\item{If more than one chort need to be compared then only "M2" method is applicable}
}
}
\examples{
cohort_path = paste0(system.file("extdata/processed_data/", package = "allMT"), "/")
compare_cohorts(input_files_path = cohort_path,
        method = "M1", intervention_date = "2020-12-01",
        unit = "billion", anc_range = c(0.75, 1.5), dose_intensity_threshold = 100)

\donttest{
group_path = system.file("extdata/grouped_data/group_data.xlsx", package = "allMT")
compare_cohorts(input_files_path = cohort_path,
       method = "M2", group_data_path = group_path,
       unit = "billion", anc_range = c(0.75, 1.5), dose_intensity_threshold = 80)
}
}
\seealso{
\code{\link[=summarize_cohortMT]{summarize_cohortMT()}}
}
