% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allocate-fixn.R, R/allocate-neyman.R,
%   R/allocate-prec.R, R/package.R
\name{Allocation-Methods}
\alias{Allocation-Methods}
\alias{allocate_fixn}
\alias{allocate_neyman}
\alias{allocate_prec}
\alias{Allocation Methods}
\title{Algorithms for Exact Optimization Allocation}
\usage{
allocate_fixn(n0, N, S, lo = NULL, hi = NULL, control = allocation_control())

allocate_neyman(n0, N, S, control = allocation_control())

allocate_prec(v0, N, S, lo = NULL, hi = NULL, control = allocation_control())
}
\arguments{
\item{n0}{Target sample size for Algorithm III; integer.}

\item{N}{Population size for each stratum; integer vector of length \code{H}.}

\item{S}{Standard deviation for each stratum; numeric vector of length \code{H}.}

\item{lo}{Sample size lower bounds for each stratum; numeric vector of
length \code{H}. Default argument \code{NULL} is transformed to a vector of ones.}

\item{hi}{Sample size upper bounds for each stratum; numeric vector of
length \code{H}. Default argument \code{NULL} is transformed to a vector of \code{Inf}.}

\item{control}{Control object from \link{allocation_control}.}

\item{v0}{Target variance for Algorithm IV; numeric.}
}
\value{
A list whose structure depends on the allocation method.

\code{allocate_neyman}
\itemize{
\item \code{n}: Integer vector with allocation \eqn{n_1, \ldots, n_H}.
\item \code{v}: Value of variance achieved at selected allocation.
\item \code{N}: The argument \code{N} passed to the function.
\item \code{S}: The argument \code{S} passed to the function.
}

\code{allocate_fixn}
\itemize{
\item \code{n}: Integer vector with allocation \eqn{n_1, \ldots, n_H}.
\item \code{iter}: Number of steps taken in the algorithm.
\item \code{v}: Value of variance achieved at selected allocation.
\item \code{N}: The argument \code{N} passed to the function.
\item \code{S}: The argument \code{S} passed to the function.
\item \code{lo}: The argument \code{lo} passed to the function.
\item \code{hi}: The argument \code{hi} passed to the function.
}

\code{allocate_prec}
\itemize{
\item \code{n}: Integer vector with allocation \eqn{n_1, \ldots, n_H}.
\item \code{iter}: Number of steps taken in the algorithm.
\item \code{v}: Value of variance achieved at selected allocation.
\item \code{v0}: The argument \code{v0} passed to the function.
\item \code{N}: The argument \code{N} passed to the function.
\item \code{S}: The argument \code{S} passed to the function.
\item \code{lo}: The argument \code{lo} passed to the function.
\item \code{hi}: The argument \code{hi} passed to the function.
}
}
\description{
Algorithms III and IV from Wright (2017), and classical unconstrained
Neyman allocation (Neyman, 1934).
}
\details{
The function \code{allocate_fixn} implements Algorithm III of Wright (2017) and
finds the optimal allocation for a given total sample size \code{n0}. The function
\code{allocate_prec} implements Algorithm IV of Wright (2017) and optimally
allocates units until the overall variance is smaller than a given \code{v0}.
Classical Neyman  allocation is implemented by the function
\code{allocate_neyman}.
}
\references{
Neyman, Jerzy (1934). On the Two Different Aspects of the Representative
Method: The Method of Stratified Sampling and the Method of Purposive
Selection. Journal of the Royal Statistical Society, 97 (4): 558-625.

Tommy Wright (2012). The Equivalence of Neyman Optimum Allocation for
Sampling and Equal Proportions for Apportioning the U.S. House of
Representatives. The American Statistician, 66, pp.217-224.

Tommy Wright (2017), Exact optimal sample allocation: More efficient than
Neyman, Statistics & Probability Letters, 129, pp.50-57.
}
