% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dual_tail.R
\name{dual_tail}
\alias{dual_tail}
\title{Discriminate between beta-sharing clones and dual-alpha TCR clones (optimized
for rare clones)}
\usage{
dual_tail(alpha, beta, freq_results, numb_cells)
}
\arguments{
\item{alpha}{Matrix recording which alpha chains appear in each well of the
data. See \code{\link{create_data}}.}

\item{beta}{Matrix recording which beta chains appear in the each well of the
data. See \code{\link{create_data}}.}

\item{freq_results}{Output of \code{\link{freq_estimate}}.}

\item{numb_cells}{Vector containing the number of cells sampled in the wells
of each column of the plates.}
}
\value{
A n x 3 matrix where n is the number of candidate clones, column 1
   is the beta index of the clone, and column 2-3 are the alpha indices of
   the clone
}
\description{
\code{dual_tail()} distinguishes between clones that share a common beta
   chain and dual TCR clones with two productive alpha chains. The procedure
   tests the null hypothesis that two candidate alpha, beta pairs with the
   same beta represent two separate clones by using the frequency estimates
   to calculate the number of wells that both clones are expected to be in.
   This is compared to the actual number of wells that both clones appear in,
   and if the actual number is greater than the expected number, than the
   pairs are chosen to represent a dual TCR clone.
}

