% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amber.interviews.R
\name{amber.interviews_step_data}
\alias{amber.interviews_step_data}
\title{Get the data of some interviews step}
\usage{
amber.interviews_step_data(steps, step_name)
}
\arguments{
\item{steps}{The data frame of interviews steps}

\item{step_name}{The name of the step}
}
\value{
A data.frame of step data
}
\description{
Get the data of the steps with a specific name.
}
\examples{
\dontrun{
a <- amber.login("https://amber-demo.obiba.org")

# Find interview records of a study
itws <- amber.interviews(a, study = "Trauma Registry")

# Get steps
steps <- amber.interviews_steps(itws)

# Get data of the step with name CONSENT
consent_data <- amber.interviews_step_data(steps, 'CONSENT')

# Count per agreement values (possible values are 0 or 1)
consent_data \%>\% count(AGREEMENT)

amber.logout(a)
}
}
\seealso{
Other studies functions: 
\code{\link{amber.campaign}()},
\code{\link{amber.campaigns}()},
\code{\link{amber.case_report_export}()},
\code{\link{amber.case_report_form}()},
\code{\link{amber.case_report_forms}()},
\code{\link{amber.case_reports}()},
\code{\link{amber.form}()},
\code{\link{amber.form_revision}()},
\code{\link{amber.form_revisions}()},
\code{\link{amber.forms}()},
\code{\link{amber.interview_design}()},
\code{\link{amber.interview_designs}()},
\code{\link{amber.interview_export}()},
\code{\link{amber.interviews}()},
\code{\link{amber.interviews_step_actions}()},
\code{\link{amber.interviews_steps}()},
\code{\link{amber.participant}()},
\code{\link{amber.participants}()},
\code{\link{amber.studies}()},
\code{\link{amber.study}()}
}
\concept{studies functions}
