% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IC-RDE.R
\name{ic.data.examp}
\alias{ic.data.examp}
\title{Function for calculating the influence function used for
the real data example.}
\usage{
ic.data.examp(obs_data, what = "both", control = NULL)
}
\arguments{
\item{obs_data}{the observed data.  The first column should be the outcome.}

\item{what}{the desired return value. Should be one of \code{"ic"}
(influence curve), \code{"est"} (estimate), or \code{"both"}.}

\item{control}{any other control parameters to be passed to the estimator.}
}
\value{
If \code{what} is

- \code{"est"}, then return the estimated parameter.

- \code{"ic"}, then return the estimated IC of the parameter estimate.

- \code{"both"}, then return both the parameter estimate and
corresponding estimated IC.
}
\description{
Function for calculating the influence function used for
the real data example.
}
\examples{

expit <- function(x) exp(x) / (1 + exp(x))
ws <- matrix(rnorm(3000), ncol = 3)
probs <- expit(ws  \%*\% c(-1, 0, 2))
y <- rbinom(n = nrow(probs), size = 1, prob = probs[, 1])
wts <-   abs(rnorm(length(y))) + 1
wts <- length(wts) * wts / sum(wts)
cats <- rep(1:10, 100)
obs_dat <- cbind(y, "cat" = cats, "wt" = wts, ws)
est_ic <- ic.data.examp(obs_dat, what = "both")
my_est <- est_ic$est
my_ic <- est_ic$ic / nrow(ws)
var_mat <- t(my_ic) \%*\% my_ic
sqrt(diag(var_mat))
for(cov_idx in 1:ncol(ws)){
 print(summary(stats::glm(y ~ ws[, cov_idx], weights = obs_dat[, "wt"],
                    family = binomial))$coefficients[2, 1:2])
}

}
