% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preop_DFRS.R
\name{preop_DFRS}
\alias{preop_DFRS}
\title{Preoperative Distal Fistula Risk Score (D-FRS)}
\usage{
preop_DFRS(my_data)
}
\arguments{
\item{my_data}{A data frame containing the columns PD_size Numeric (Pancreatic duct diameter in millimeters) and PT (Pancreatic thickness (in mm))}
}
\value{
A data frame with the (D-FRS) score and risk classification of POPF. Returns NA for cases with missing values.
}
\description{
The preoperative fistula risk score estimates the probability of clinically relevant (grade B/C) postoperative pancreatic fistula (POPF) based on the 2016 ISGPS definition.
It is the first validated risk score for POPF after distal pancreatectomy, categorizing patients into three risk groups for personalized treatment and benchmarking.
For more information, visit \url{https://www.evidencio.com/models/show/2573}.
}
\details{
The function calculates the (D-FRS)score based on the following parameters:
\itemize{
\item \code{PT:} Size of the pancreatic thickness in mm
\item \code{PD_size:} Size of the pancreatic duct in mm
}
}
\examples{
my_data <- data.frame(ID = 1:4,
PT = c(5, 43, 1, 4),
PD_size = c(25, 5, 1, 19) )

preop_DFRS(my_data)
}
\references{
Pastena et al. (2023) \url{doi:10.1097/SLA.0000000000005497}
}
