% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_tree.R
\name{load_tree_df_path}
\alias{load_tree_df_path}
\title{Build a decision tree from a path-string data frame}
\usage{
load_tree_df_path(df, delim = "/")
}
\arguments{
\item{df}{A data frame with a column named \code{path} containing the node paths,
and other optional attribute columns like \code{question} and \code{rule}.}

\item{delim}{The character used to separate nodes in the path string.
Defaults to "/".}
}
\value{
A \code{data.tree} object.
}
\description{
Constructs a tree from a data frame that is already in memory,
where the hierarchy is defined using a path string for each node (e.g.,
"Root/Branch/Leaf").
}
\details{
This is a core constructor function, typically called by a wrapper
like \code{load_tree_csv_path()}, which handles reading the data from a file.
The node's name is inferred from the last element of its path.
}
\examples{

# Create a sample data frame in path format
path_df <- data.frame(
  path = c("Root", "Root/Branch1", "Root/Branch1/LeafA", "Root/Branch2"),
  rule = c("AND", "OR", NA, NA),
  question = c(NA, "Is Branch1 relevant?", "Is LeafA true?", "Is Branch2 true?")
)

# Build the tree
my_tree <- load_tree_df_path(path_df)
print(my_tree)

}
\seealso{
\code{\link[=load_tree_csv_path]{load_tree_csv_path()}} to read this format from a file.
}
