% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/angstroms.R
\name{romscoords}
\alias{romscoords}
\title{Extract coordinate arrays from ROMS.}
\usage{
romscoords(x, spatial = c("lon_u", "lat_u"), ncdf = TRUE,
  transpose = FALSE, ...)
}
\arguments{
\item{x}{ROMS file name}

\item{spatial}{names of coordinate variables (e.g. lon_u, lat_u)}

\item{ncdf}{default to NetCDF no matter what file name}

\item{transpose}{the extents (ROMS is FALSE, Access is TRUE)}

\item{...}{unused}
}
\value{
RasterStack with two layers of the 2D-variables
}
\description{
Returns a RasterStack of the given variable names.
}
\details{
The two layers from the model output are used to define the real-world space. This is used to create a boundary \code{romsboundary}, to map real-world
objects into  grid space \code{romscoords} and to generate graticules for mapping into the grid space with \code{graphics::contour}.
}
\examples{
\dontrun{
  coord <- romscoord("roms.nc")
}
## with in-built fake data
plot(ice_fake, asp = 0.5)
contour(ice_coords[[1]], add = TRUE, levels = seq(-165, 165, by = 15))
contour(ice_coords[[2]], add = TRUE)

}
