% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/bard.R, R/capa.R, R/pass.class.R
\docType{methods}
\name{collective_anomalies}
\alias{collective_anomalies}
\alias{collective_anomalies,bard.sampler.class-method}
\alias{collective_anomalies,capa.class-method}
\alias{collective_anomalies,pass.class-method}
\title{Collective anomaly location, lags, and mean/variance changes.}
\usage{
collective_anomalies(object, ...)

\S4method{collective_anomalies}{bard.sampler.class}(object)

\S4method{collective_anomalies}{capa.class}(object, epoch = nrow(object@data), merged = FALSE)

\S4method{collective_anomalies}{pass.class}(object)
}
\arguments{
\item{object}{An instance of an S4 class produced by \code{\link{capa}}.}

\item{...}{TODO}

\item{epoch}{Positive integer. CAPA methods are sequential and as such, can generate results up to, and including, any epoch within the data series. This can be controlled by the value
of \code{epoch} and is useful for examining how the inferred anomalies are modified as the data series grows. The default value for \code{epoch} is the length of the data series.}

\item{merged}{Boolean value. If \code{merged=TRUE} then collective anomalies that are common across multiple variates are merged together. This is useful when comparing the relative strength
of multivariate collective anomalies. Default value is \code{merged=FALSE}. Note - \code{merged=TRUE} is currently only available when \code{type="mean"}.}
}
\value{
A data frame.
}
\description{
Creates a data frame containing collective anomaly locations, lags and changes in mean and variance as detected by \code{\link{capa}}, \code{\link{pass}}, and \code{\link{sampler}}. 

For an object created by \code{\link{capa}} returns a data frame with columns containing the start and end position of the anomaly, the change in mean
due to the anomaly. For multivariate data a data frame with columns containing the start and end position of the anomaly, the variates 
affected by the anomaly, as well as their the start and end lags. When \code{type="mean"/"robustmean"} only the change in mean is reported. When \code{type="meanvar"} both the change in mean and
change in variance are included. If \code{merged=FALSE} (the default), then all the collective anomalies are processed individually even if they are common across multiple variates.
If \code{merged=TRUE}, then the collective anomalies are grouped together across all variates that they appear in.

For an object produced by \code{\link{pass}} or \code{sampler} returns a data frame containing the start, end and strength of the collective anomalies.
}
\seealso{
\code{\link{capa}},\code{\link{pass}},\code{\link{sampler}}.
}
