% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{check_data}
\alias{check_data}
\title{Checks data are correctly described for models}
\usage{
check_data(
  data = data,
  time = time,
  censor = censor,
  infected_treatment = infected_treatment
)
}
\arguments{
\item{data}{Name of data.frame to be checked}

\item{time}{Name of column with time of event data (death or censoring);

requires time > 0 and numeric.}

\item{censor}{Name of column containing censor status;

 '1' censored,

 '0' uncensored or died during experiment

 (needs to be numeric)}

\item{infected_treatment}{Name of column for infection treatment status;

'1' a treatment exposed to infection,

'0' treatment not exposed to infection

(needs to be numeric).

NB Different likelihood models make different assumptions as to whether
all the individuals in an infected treatment are infected
or not (c.f. \code{\link{nll_exposed_infected}})}
}
\value{
Message, 'Checks completed' or error message
}
\description{
Function checking 'time', 'censor' and 'infected treatment'
columns in data.frame are correctly specified for the
likelihood functions in this package.
}
\details{
An error message is also given if data contain rows 'NA';
these need removing.

NB error messages triggered on 1st encounter with a fault.
Correct and check revised data for other faults.
}
\examples{
\donttest{
# view head of data.frame to be checked
  head(data_blanford, 3)

# specify data.frame and names of columns for;
  # time, censor status, infection status
  check_data(data = data_blanford,
             time = t,
             censor = censor,
             infected_treatment = inf)

# create data.frame 't_zero' with t = 0 in first row of data.frame
t_zero <- data_blanford
t_zero[1, 8] <- 0
head(t_zero, 3)

check_data(data = t_zero,
           time = t,
           censor = censor,
           infected_treatment = inf)

# correct '0' and make first row of column 'censor' = NA
  t_zero[1, 8] <- 1 ; t_zero[1, 5] <- NA ; head(t_zero, 3)

check_data(data = t_zero,
           time = t,
           censor = censor,
           infected_treatment = inf)

# remove row(s) with 'NA'
  t_zero_II <- na.omit(t_zero) # NB applies to whole data.frame
  check_data(data = t_zero_II,
           time = t,
           censor = censor,
           infected_treatment = inf)

}
}
