% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apa_correlation.R
\name{apa.r}
\alias{apa.r}
\title{Report r(x,y) correlation in markdown APA style}
\usage{
apa.r(
  .data,
  .x,
  .y,
  alternative = "two.sided",
  method = "pearson",
  show.r = TRUE,
  show.conf.interval = NULL,
  show.N = NULL,
  show.p = NULL,
  show.statistic = NULL,
  number.decimals = NULL,
  number.decimals.p = NULL
)
}
\arguments{
\item{.data}{A data frame or data frame extension (e.g., tibble)}

\item{.x}{Name of column in data frame}

\item{.y}{Name of column in data frame}

\item{alternative}{Alternative hypothesis to pass to alternative argument of cor.test. Default is "two.sided"}

\item{method}{Calculation method to pass to alternative argument of cor.test. Default is "pearson"}

\item{show.r}{Show correlation or not (TRUE/FALSE)}

\item{show.conf.interval}{Show confidence interval or not (TRUE/FALSE). Default behavior is TRUE.}

\item{show.N}{Show sample size or not (TRUE/FALSE). Default behavior is TRUE.}

\item{show.p}{Show p-value or not (TRUE/FALSE). Default behavior is TRUE.}

\item{show.statistic}{Show test statistic or not (TRUE/FALSE). Default behavior is TRUE.}

\item{number.decimals}{Number of decimals used in output (excluding p-value)}

\item{number.decimals.p}{Number of decimals used in output for p-value}
}
\value{
R Markdown text
}
\description{
Report r(x,y) correlation in markdown APA style
}
\examples{
library(dplyr)
attitude \%>\% apa.r(rating, advance)
}
