% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef_compare.R
\name{coef_compare}
\alias{coef_compare}
\title{Compare coefficients of 2 models}
\usage{
coef_compare(model1, model2, digits = 3, verbose = TRUE)
}
\arguments{
\item{model1}{A fitted model object from the
\code{\link[stats]{lm}} function.}

\item{model2}{A fitted model object from the
\code{\link[stats]{lm}} function.}

\item{digits}{A positive integer indicating how many
significant digits are to be used for numeric and
complex numbers. This argument is passed to
\code{\link[base]{format}}.}

\item{verbose}{A logical value indicating whether the
matrix should be printed. The default is \code{TRUE}.}
}
\value{
A matrix.
}
\description{
Compare the coefficients to two fitted models. The models
must have the same coefficients.
}
\examples{
# fit model
lmod1 <- lm(murder ~ hs_grad + urban + poverty + single,
           data = crime2009)
#fit without DC
lmod2 <- lm(murder ~ hs_grad + urban + poverty + single,
            data = crime2009[-9, ])
#compare coefficients of models
coef_compare(lmod1, lmod2)
}
