% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dffits_plot.R
\name{dffits_plot}
\alias{dffits_plot}
\title{Index plot of DFFITS values for \code{lm} object}
\usage{
dffits_plot(
  model,
  id_n = 3,
  add_reference = TRUE,
  ...,
  text_arglist = list(),
  abline_arglist = list(),
  extendrange_f = 0.08
)
}
\arguments{
\item{model}{A fitted model object from the
\code{\link[stats]{lm}} function.}

\item{id_n}{The number of points to identify with labels.
The default is \code{3}.}

\item{add_reference}{A logical value indicating whether a
reference line should be added. The default is
\code{TRUE}. See Details.}

\item{...}{Additional arguments passed to the
\code{\link[graphics]{plot}} function.}

\item{text_arglist}{Additional arguments passed to the
\code{\link[graphics]{text}} function, which is used to
display the points that are identified.}

\item{abline_arglist}{A named list specifying additional
arguments passed to the \code{\link[graphics]{abline}}
function for the horizontal reference line added to the
plot.}

\item{extendrange_f}{Positive number(s) specifying the
fraction by which the range of the residuals should be
extended using the \code{\link[grDevices]{extendrange}}
function. If longer than one, \code{f[1]} is used on
the left and \code{f[2]} on the right.}
}
\description{
\code{dffits_plot} plots the DFFITS values from
the \code{\link[stats]{dffits}} function of a fitted
\code{lm} object.
}
\details{
By default, a reference line is plotted at \eqn{\pm 2\sqrt{p/n}},
where \eqn{p = }\code{length(stats::coef(model))} and
\eqn{n = }\code{stats::nobs(model)}. This can be customized
by setting the \code{h} argument of \code{abline_arglist}.
}
\examples{
lmod <- lm(price ~ sqft_living, data = home_sales)
dffits_plot(lmod, id_n = 6)
# customized plot
dffits_plot(lmod, id_n = 1,
            text_arglist = list(col = "blue", cex = 2),
            abline_arglist = list(col = "red", lwd = 2))
}
\seealso{
\code{\link[graphics]{plot}},
  \code{\link[graphics]{text}},
  \code{\link[graphics]{abline}},
  \code{\link[stats]{dffits}}
}
\author{
Joshua French
}
