% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apollo_mixUnconditionals.R
\name{apollo_mixUnconditionals}
\alias{apollo_mixUnconditionals}
\title{Returns draws for continuously distributed random parameters in mixture model}
\usage{
apollo_mixUnconditionals(
  model,
  apollo_probabilities,
  apollo_inputs,
  obsLevel = FALSE
)
}
\arguments{
\item{model}{Model object. Estimated model object as returned by function \link{apollo_estimate}.}

\item{apollo_probabilities}{Function. Returns probabilities of the model to be estimated. Must receive three arguments:
\itemize{
  \item \strong{\code{apollo_beta}}: Named numeric vector. Names and values of model parameters.
  \item \strong{\code{apollo_inputs}}: List containing options of the model. See \link{apollo_validateInputs}.
  \item \strong{\code{functionality}}: Character. Can be either \strong{\code{"components"}}, \strong{\code{"conditionals"}}, \strong{\code{"estimate"}} (default), \strong{\code{"gradient"}}, \strong{\code{"output"}}, \strong{\code{"prediction"}}, \strong{\code{"preprocess"}}, \strong{\code{"raw"}}, \strong{\code{"report"}}, \strong{\code{"shares_LL"}}, \strong{\code{"validate"}} or \strong{\code{"zero_LL"}}.
}}

\item{apollo_inputs}{List grouping most common inputs. Created by function \link{apollo_validateInputs}.}

\item{obsLevel}{Logical. If \code{TRUE}, unconditionals are returned at the observation level rather than person level. This setting only applies to continuous mixture models and is set to TRUE by default only in the presence of intra-individual draws. Otherwise, the default is FALSE.}
}
\value{
List of object, one per random coefficient.
        With inter-individual draws only, this will be a matrix, with one row per individual, and one column per draw.
        With intra-individual draws, this will be a three-dimensional array, with one row per observation, inter-individual draws in the second dimension, and intra-individual draws in the third dimension.
}
\description{
Returns draws (unconditionals) for random parameters in model, including interactions with deterministic covariates.
}
\details{
This functions is only meant for use with continuous distributions
}
