% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Q.iid.R, R/r.iid.R
\name{Q.iid}
\alias{Q.iid}
\alias{r.iid}
\title{Precision matrix for a IID process}
\usage{
Q.iid(M, sigma, sparse=FALSE,  vcov=FALSE)

r.iid(n, M, sigma)
}
\arguments{
\item{M}{int > 0, number of elements in the process.}

\item{sigma}{float > 0, standard deviat}

\item{sparse}{bool Should the matrix be of class 'dsCMatrix'}

\item{vcov}{bool If the vcov matrix should be returned instead of the
precision matrix.}

\item{n}{int > 0, number of observations to simulate from the GMRF.}
}
\value{
Q.iid returns either a precision or variance-covariance function
with iid structure.

r.iid retrurns a matrix with n rows which are the n observations of a
Gaussian Markov random field iid process.
}
\description{
Functions for creating precision matricies and observations
of a independent identically distributed GMRF process.
}
\examples{
require("leaflet")
require("sp")

# simulate iid data and attach to spatial polygons data frame
US.df@data$data <- c(r.iid(1, M=nrow(US.graph), sigma=1))

# color palette of data
pal <- colorNumeric(palette="YlGnBu", domain=US.df@data$data)

# see map
map1<-leaflet() \%>\%
    addProviderTiles("CartoDB.Positron") \%>\%
    addPolygons(data=US.df, fillColor=~pal(data), color="#b2aeae",
                fillOpacity=0.7, weight=0.3, smoothFactor=0.2) \%>\%
    addLegend("bottomright", pal=pal, values=US.df$data, title="", opacity=1)
map1

}
